/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.common.lib.types.PropagationTaskExecStatus;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.PropagationTaskCheck;

public class PropagationTaskValidator
extends AbstractValidator<PropagationTaskCheck, PropagationTask> {
    public boolean isValid(PropagationTask task, ConstraintValidatorContext context) {
        boolean isValid;
        if (task == null) {
            isValid = true;
        } else {
            boolean bl = isValid = task.getOperation() != null && !task.getAttributes().isEmpty() && task.getResource() != null;
            if (isValid) {
                List executions = task.getExecs();
                for (TaskExec execution : executions) {
                    try {
                        PropagationTaskExecStatus.valueOf((String)execution.getStatus());
                    }
                    catch (IllegalArgumentException e) {
                        LOG.error("Invalid execution status '" + execution.getStatus() + "'", (Throwable)e);
                        isValid = false;
                    }
                }
            }
            if (!isValid) {
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidPropagationTask, "Invalid task")).addPropertyNode(task.getClass().getSimpleName()).addConstraintViolation();
            }
        }
        return isValid;
    }
}

