/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.PlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.PlainAttrValueCheck;

public class PlainAttrValueValidator
extends AbstractValidator<PlainAttrValueCheck, PlainAttrValue> {
    public boolean isValid(PlainAttrValue object, ConstraintValidatorContext context) {
        boolean isValid;
        if (object == null) {
            isValid = true;
        } else {
            PlainSchema attrSchema;
            PlainSchema uniqueValueSchema;
            int nonNullVales = 0;
            if (object.getBooleanValue() != null) {
                ++nonNullVales;
            }
            if (object.getDateValue() != null) {
                ++nonNullVales;
            }
            if (object.getDoubleValue() != null) {
                ++nonNullVales;
            }
            if (object.getLongValue() != null) {
                ++nonNullVales;
            }
            if (object.getBinaryValue() != null) {
                ++nonNullVales;
            }
            if (object.getStringValue() != null) {
                ++nonNullVales;
            }
            boolean bl = isValid = nonNullVales == 1;
            if (!isValid) {
                LOG.error("More than one non-null value for " + object);
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.MoreThanOneNonNull, "More than one non-null value found")).addPropertyNode(object.getClass().getSimpleName().replaceAll("\\n", " ")).addConstraintViolation();
            } else if (object instanceof PlainAttrUniqueValue && !(isValid = (uniqueValueSchema = ((PlainAttrUniqueValue)object).getSchema()).equals(attrSchema = object.getAttr().getSchema()))) {
                LOG.error("Unique value schema for " + object.getClass().getSimpleName() + "[" + object.getKey() + "] is " + uniqueValueSchema + ", while owning attribute schema is " + attrSchema);
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidPlainAttr, "Unique value schema is " + uniqueValueSchema + ", while owning attribute schema is " + attrSchema)).addPropertyNode("schema").addConstraintViolation();
            }
        }
        return isValid;
    }
}

