/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.PlainAttrCheck;

public class PlainAttrValidator
extends AbstractValidator<PlainAttrCheck, PlainAttr<?>> {
    public boolean isValid(PlainAttr<?> object, ConstraintValidatorContext context) {
        boolean isValid;
        if (object == null) {
            isValid = true;
        } else {
            if (object.getSchema().isUniqueConstraint()) {
                isValid = object.getValues().isEmpty() && object.getUniqueValue() != null;
            } else {
                boolean bl = isValid = !object.getValues().isEmpty() && object.getUniqueValue() == null;
                if (!object.getSchema().isMultivalue()) {
                    isValid &= object.getValues().size() == 1;
                }
            }
            if (!isValid) {
                LOG.error("Invalid values for attribute " + object + ": schema=" + object.getSchema().getKey() + ", values={}", (Object)object.getValuesAsStrings());
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidValueList, "Invalid values " + object.getValuesAsStrings())).addPropertyNode(object.getSchema().getKey()).addConstraintViolation();
            }
        }
        return isValid;
    }
}

