/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import java.util.HashSet;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.Mapping;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnit;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.ExternalResourceCheck;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.identityconnectors.framework.common.objects.ObjectClass;

public class ExternalResourceValidator
extends AbstractValidator<ExternalResourceCheck, ExternalResource> {
    private boolean isValid(List<? extends Item> items, ConstraintValidatorContext context) {
        long connObjectKeys = IterableUtils.countMatches(items, (Predicate)new Predicate<Item>(){

            public boolean evaluate(Item item) {
                return item.isConnObjectKey();
            }
        });
        if (connObjectKeys != 1L) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidMapping, "Single ConnObjectKey mapping is required")).addPropertyNode("connObjectKey.size").addConstraintViolation();
            return false;
        }
        boolean isValid = true;
        for (Item item : items) {
            for (String className : item.getTransformerClassNames()) {
                Class<?> actionsClass = null;
                boolean isAssignable = false;
                try {
                    actionsClass = Class.forName(className);
                    isAssignable = ItemTransformer.class.isAssignableFrom(actionsClass);
                }
                catch (Exception e) {
                    LOG.error("Invalid ItemTransformer specified: {}", (Object)className, (Object)e);
                }
                if (actionsClass != null && isAssignable) continue;
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidMapping, "Invalid item trasformer class name")).addPropertyNode("itemTransformerClassName").addConstraintViolation();
                isValid = false;
            }
        }
        return isValid;
    }

    private boolean isValid(OrgUnit orgUnit, ConstraintValidatorContext context) {
        if (orgUnit == null) {
            return true;
        }
        return this.isValid(orgUnit.getItems(), context);
    }

    private boolean isValid(Mapping mapping, ConstraintValidatorContext context) {
        if (mapping == null) {
            return true;
        }
        boolean isValid = true;
        long passwords = IterableUtils.countMatches((Iterable)mapping.getItems(), (Predicate)new Predicate<MappingItem>(){

            public boolean evaluate(MappingItem item) {
                return item.isPassword();
            }
        });
        if (passwords > 1L) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidMapping, "One password mapping is allowed at most")).addPropertyNode("password.size").addConstraintViolation();
            isValid = false;
        }
        return isValid && this.isValid(mapping.getItems(), context);
    }

    public boolean isValid(ExternalResource resource, final ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if (resource.getKey() == null || !KEY_PATTERN.matcher(resource.getKey()).matches()) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidKey, "Invalid resource key")).addPropertyNode("key").addConstraintViolation();
            return false;
        }
        if (!resource.getPropagationActionsClassNames().isEmpty()) {
            for (String className : resource.getPropagationActionsClassNames()) {
                Class<?> actionsClass = null;
                boolean isAssignable = false;
                try {
                    actionsClass = Class.forName(className);
                    isAssignable = PropagationActions.class.isAssignableFrom(actionsClass);
                }
                catch (Exception e) {
                    LOG.error("Invalid PropagationActions specified: {}", (Object)className, (Object)e);
                }
                if (actionsClass != null && isAssignable) continue;
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidResource, "Invalid actions class name")).addPropertyNode("actionsClassName").addConstraintViolation();
                return false;
            }
        }
        final HashSet anyTypes = new HashSet();
        final HashSet objectClasses = new HashSet();
        boolean validMappings = IterableUtils.matchesAll((Iterable)resource.getProvisions(), (Predicate)new Predicate<Provision>(){

            public boolean evaluate(Provision provision) {
                anyTypes.add(provision.getAnyType());
                if (provision.getObjectClass() != null) {
                    objectClasses.add(provision.getObjectClass().getObjectClassValue());
                }
                return ExternalResourceValidator.this.isValid(provision.getMapping(), context);
            }
        });
        validMappings &= this.isValid(resource.getOrgUnit(), context);
        if (anyTypes.size() < resource.getProvisions().size()) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidResource, "Each provision requires a different " + AnyType.class.getSimpleName())).addPropertyNode("provisions").addConstraintViolation();
            return false;
        }
        if (objectClasses.size() < resource.getProvisions().size()) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidResource, "Each provision requires a different" + ObjectClass.class.getSimpleName())).addPropertyNode("provisions").addConstraintViolation();
            return false;
        }
        return validMappings;
    }
}

