/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.AnyTypeCheck;

public class AnyTypeValidator
extends AbstractValidator<AnyTypeCheck, AnyType> {
    public boolean isValid(AnyType object, ConstraintValidatorContext context) {
        boolean isValid;
        context.disableDefaultConstraintViolation();
        switch (object.getKind()) {
            case USER: {
                isValid = AnyTypeKind.USER.name().equalsIgnoreCase(object.getKey());
                break;
            }
            case GROUP: {
                isValid = AnyTypeKind.GROUP.name().equalsIgnoreCase(object.getKey());
                break;
            }
            default: {
                boolean bl = isValid = !AnyTypeKind.USER.name().equalsIgnoreCase(object.getKey()) && !AnyTypeKind.GROUP.name().equalsIgnoreCase(object.getKey()) && !"REALM".equalsIgnoreCase(object.getKey());
            }
        }
        if (!isValid) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidAnyType, "Name / kind mismatch")).addPropertyNode("name").addConstraintViolation();
        }
        return isValid;
    }
}

