/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.spring;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.ValidationMode;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.DomainsHolder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;

public class CommonEntityManagerFactoryConf
implements DomainsHolder,
InitializingBean,
ApplicationContextAware {
    private ApplicationContext ctx;
    private final Map<String, DataSource> domains = new HashMap<String, DataSource>();
    private String[] packagesToScan;
    private ValidationMode validationMode;
    private PersistenceUnitPostProcessor[] postProcessors;
    private final Map<String, Object> jpaPropertyMap = new HashMap<String, Object>();

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.ctx = ctx;
    }

    public void afterPropertiesSet() {
        for (Map.Entry entry : this.ctx.getBeansOfType(DataSource.class).entrySet()) {
            if (((String)entry.getKey()).startsWith("local")) continue;
            this.domains.put(StringUtils.substringBefore((String)((String)entry.getKey()), (String)DataSource.class.getSimpleName()), (DataSource)entry.getValue());
        }
    }

    public Map<String, DataSource> getDomains() {
        return this.domains;
    }

    public String[] getPackagesToScan() {
        return this.packagesToScan;
    }

    public void setPackagesToScan(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public PersistenceUnitPostProcessor[] getPersistenceUnitPostProcessors() {
        return this.postProcessors;
    }

    public void setPersistenceUnitPostProcessors(PersistenceUnitPostProcessor ... postProcessors) {
        this.postProcessors = postProcessors;
    }

    public Map<String, ?> getJpaPropertyMap() {
        return this.jpaPropertyMap;
    }

    public void setJpaPropertyMap(Map<String, ?> jpaProperties) {
        if (jpaProperties != null) {
            this.jpaPropertyMap.putAll(jpaProperties);
        }
    }
}

