/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Size;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.AnyTemplate;
import org.apache.syncope.core.persistence.api.entity.AnyTemplateRealm;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyTemplateRealm;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAAccountPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPasswordPolicy;
import org.apache.syncope.core.persistence.jpa.entity.resource.JPAExternalResource;
import org.apache.syncope.core.persistence.jpa.validation.entity.RealmCheck;
import org.apache.syncope.core.provisioning.api.utils.EntityUtils;

@Entity
@Table(name="Realm", uniqueConstraints={@UniqueConstraint(columnNames={"name", "parent_id"})})
@Cacheable
@RealmCheck
public class JPARealm
extends AbstractGeneratedKeyEntity
implements Realm,
PersistenceCapable {
    private static final long serialVersionUID = 5533247460239909964L;
    public static final String TABLE = "Realm";
    @Size(min=1)
    private String name;
    @ManyToOne
    private JPARealm parent;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAPasswordPolicy passwordPolicy;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAAccountPolicy accountPolicy;
    @ElementCollection(fetch=FetchType.EAGER)
    @Column(name="actionClassName")
    @CollectionTable(name="Realm_actionsClassNames", joinColumns={@JoinColumn(name="realm_id", referencedColumnName="id")})
    private Set<String> actionsClassNames = new HashSet<String>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER, mappedBy="realm")
    private List<JPAAnyTemplateRealm> templates = new ArrayList<JPAAnyTemplateRealm>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(joinColumns={@JoinColumn(name="realm_id")}, inverseJoinColumns={@JoinColumn(name="resource_id")})
    private List<JPAExternalResource> resources = new ArrayList<JPAExternalResource>();
    private static int pcInheritedFieldCount = AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPasswordPolicy;
    static /* synthetic */ Class class$Ljava$util$List;

    public String getName() {
        return JPARealm.pcGetname(this);
    }

    public Realm getParent() {
        return JPARealm.pcGetparent(this);
    }

    public String getFullPath() {
        return this.getParent() == null ? "/" : StringUtils.appendIfMissing((String)this.getParent().getFullPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + this.getName();
    }

    public AccountPolicy getAccountPolicy() {
        return JPARealm.pcGetaccountPolicy(this) == null && this.getParent() != null ? this.getParent().getAccountPolicy() : JPARealm.pcGetaccountPolicy(this);
    }

    public PasswordPolicy getPasswordPolicy() {
        return JPARealm.pcGetpasswordPolicy(this) == null && this.getParent() != null ? this.getParent().getPasswordPolicy() : JPARealm.pcGetpasswordPolicy(this);
    }

    public void setName(String name) {
        JPARealm.pcSetname(this, name);
    }

    public void setParent(Realm parent) {
        this.checkType(parent, JPARealm.class);
        JPARealm.pcSetparent(this, (JPARealm)parent);
    }

    public void setAccountPolicy(AccountPolicy accountPolicy) {
        this.checkType(accountPolicy, JPAAccountPolicy.class);
        JPARealm.pcSetaccountPolicy(this, (JPAAccountPolicy)accountPolicy);
    }

    public void setPasswordPolicy(PasswordPolicy passwordPolicy) {
        this.checkType(passwordPolicy, JPAPasswordPolicy.class);
        JPARealm.pcSetpasswordPolicy(this, (JPAPasswordPolicy)passwordPolicy);
    }

    public Set<String> getActionsClassNames() {
        return JPARealm.pcGetactionsClassNames(this);
    }

    public boolean add(AnyTemplateRealm template) {
        this.checkType(template, JPAAnyTemplateRealm.class);
        return JPARealm.pcGettemplates(this).add((JPAAnyTemplateRealm)template);
    }

    public AnyTemplateRealm getTemplate(final AnyType anyType) {
        return (AnyTemplateRealm)IterableUtils.find((Iterable)JPARealm.pcGettemplates(this), (Predicate)new Predicate<AnyTemplate>(){

            public boolean evaluate(AnyTemplate template) {
                return anyType != null && anyType.equals(template.getAnyType());
            }
        });
    }

    public List<? extends AnyTemplateRealm> getTemplates() {
        return JPARealm.pcGettemplates(this);
    }

    public boolean add(ExternalResource resource) {
        this.checkType(resource, JPAExternalResource.class);
        return JPARealm.pcGetresources(this).add((JPAExternalResource)resource);
    }

    public List<String> getResourceKeys() {
        return (List)CollectionUtils.collect(this.getResources(), (Transformer)EntityUtils.keyTransformer(), new ArrayList());
    }

    public List<? extends ExternalResource> getResources() {
        return JPARealm.pcGetresources(this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"accountPolicy", "actionsClassNames", "name", "parent", "passwordPolicy", "resources", "templates"};
        Class[] classArray = new Class[7];
        Class clazz2 = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.policy.JPAAccountPolicy"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = JPARealm.class$("java.util.Set"));
        classArray[1] = clazz3;
        Class clazz4 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPARealm.class$("java.lang.String"));
        classArray[2] = clazz4;
        Class clazz5 = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.JPARealm"));
        classArray[3] = clazz5;
        Class clazz6 = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPasswordPolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPasswordPolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPasswordPolicy = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.policy.JPAPasswordPolicy"));
        classArray[4] = clazz6;
        Class clazz7 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPARealm.class$("java.util.List"));
        classArray[5] = clazz7;
        classArray[6] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPARealm.class$("java.util.List"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 10, 26, 26, 26, 5, 10};
        PCRegistry.register((Class)(class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.JPARealm"))), (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPARealm", (PersistenceCapable)new JPARealm());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.accountPolicy = null;
        this.actionsClassNames = null;
        this.name = null;
        this.parent = null;
        this.passwordPolicy = null;
        this.resources = null;
        this.templates = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPARealm jPARealm = new JPARealm();
        if (bl) {
            jPARealm.pcClearFields();
        }
        jPARealm.pcStateManager = stateManager;
        jPARealm.pcCopyKeyFieldsFromObjectId(object);
        return jPARealm;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPARealm jPARealm = new JPARealm();
        if (bl) {
            jPARealm.pcClearFields();
        }
        jPARealm.pcStateManager = stateManager;
        return jPARealm;
    }

    protected static int pcGetManagedFieldCount() {
        return 7 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.accountPolicy = (JPAAccountPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.actionsClassNames = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.parent = (JPARealm)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.passwordPolicy = (JPAPasswordPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.resources = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.templates = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.accountPolicy);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.actionsClassNames);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.parent);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.passwordPolicy);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.resources);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.templates);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPARealm jPARealm, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPARealm, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.accountPolicy = jPARealm.accountPolicy;
                return;
            }
            case 1: {
                this.actionsClassNames = jPARealm.actionsClassNames;
                return;
            }
            case 2: {
                this.name = jPARealm.name;
                return;
            }
            case 3: {
                this.parent = jPARealm.parent;
                return;
            }
            case 4: {
                this.passwordPolicy = jPARealm.passwordPolicy;
                return;
            }
            case 5: {
                this.resources = jPARealm.resources;
                return;
            }
            case 6: {
                this.templates = jPARealm.templates;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPARealm jPARealm = (JPARealm)object;
        if (jPARealm.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPARealm, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.JPARealm"));
        return clazz;
    }

    private static final JPAAccountPolicy pcGetaccountPolicy(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.accountPolicy;
        }
        int n = pcInheritedFieldCount + 0;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.accountPolicy;
    }

    private static final void pcSetaccountPolicy(JPARealm jPARealm, JPAAccountPolicy jPAAccountPolicy) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.accountPolicy = jPAAccountPolicy;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 0, (Object)jPARealm.accountPolicy, (Object)jPAAccountPolicy, 0);
    }

    private static final Set pcGetactionsClassNames(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.actionsClassNames;
        }
        int n = pcInheritedFieldCount + 1;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.actionsClassNames;
    }

    private static final void pcSetactionsClassNames(JPARealm jPARealm, Set set) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.actionsClassNames = set;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 1, jPARealm.actionsClassNames, (Object)set, 0);
    }

    private static final String pcGetname(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.name;
        }
        int n = pcInheritedFieldCount + 2;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.name;
    }

    private static final void pcSetname(JPARealm jPARealm, String string) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.name = string;
            return;
        }
        jPARealm.pcStateManager.settingStringField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 2, jPARealm.name, string, 0);
    }

    private static final JPARealm pcGetparent(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.parent;
        }
        int n = pcInheritedFieldCount + 3;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.parent;
    }

    private static final void pcSetparent(JPARealm jPARealm, JPARealm jPARealm2) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.parent = jPARealm2;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 3, (Object)jPARealm.parent, (Object)jPARealm2, 0);
    }

    private static final JPAPasswordPolicy pcGetpasswordPolicy(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.passwordPolicy;
        }
        int n = pcInheritedFieldCount + 4;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.passwordPolicy;
    }

    private static final void pcSetpasswordPolicy(JPARealm jPARealm, JPAPasswordPolicy jPAPasswordPolicy) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.passwordPolicy = jPAPasswordPolicy;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 4, (Object)jPARealm.passwordPolicy, (Object)jPAPasswordPolicy, 0);
    }

    private static final List pcGetresources(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.resources;
        }
        int n = pcInheritedFieldCount + 5;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.resources;
    }

    private static final void pcSetresources(JPARealm jPARealm, List list) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.resources = list;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 5, jPARealm.resources, (Object)list, 0);
    }

    private static final List pcGettemplates(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.templates;
        }
        int n = pcInheritedFieldCount + 6;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.templates;
    }

    private static final void pcSettemplates(JPARealm jPARealm, List list) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.templates = list;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 6, jPARealm.templates, (Object)list, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

