/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.util.Date;
import org.apache.syncope.core.persistence.api.entity.AnnotatedEntity;
import org.apache.syncope.core.persistence.jpa.entity.AnnotatedEntityListener;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSysInfoListener {
    protected static final Logger LOG = LoggerFactory.getLogger(AnnotatedEntityListener.class);

    protected void setSysInfoOnAnnotatedEntity(AnnotatedEntity entity) {
        String username = AuthContextUtils.getUsername();
        LOG.debug("Set system properties for '{}'", (Object)entity);
        Date now = new Date();
        if (entity.getCreationDate() == null) {
            LOG.debug("Set creation date '{}' and creator '{}' for '{}'", new Object[]{now, username, entity});
            entity.setCreationDate(now);
            entity.setCreator(username);
        }
        LOG.debug("Set last change date '{}' and modifier '{}' for '{}'", new Object[]{now, username, entity});
        entity.setLastModifier(username);
        entity.setLastChangeDate(now);
    }
}

