/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public abstract class AbstractEntity
implements Entity {
    private static final long serialVersionUID = -9017214159540857901L;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractEntity.class);

    protected void checkType(Object object, Class<?> clazz) {
        if (object != null && !clazz.isInstance(object)) {
            throw new ClassCastException("Expected " + clazz.getName() + ", got " + object.getClass().getName());
        }
    }

    public final boolean isBooleanAsInteger(Integer property) {
        return property != null && property == 1;
    }

    public final Integer getBooleanAsInteger(Boolean value) {
        return Boolean.TRUE.equals(value) ? 1 : 0;
    }

    private String[] getExcludeFields() {
        HashSet<String> excludeFields = new HashSet<String>();
        for (PropertyDescriptor propDesc : BeanUtils.getPropertyDescriptors(this.getClass())) {
            if (!propDesc.getPropertyType().isInstance(Collections.emptySet()) && !propDesc.getPropertyType().isInstance(Collections.emptyList())) continue;
            excludeFields.add(propDesc.getName());
        }
        return excludeFields.toArray(new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])this.getExcludeFields());
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])this.getExcludeFields());
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.getKey() + ']';
    }
}

