/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;

class SearchSupport {
    protected final AnyTypeKind anyTypeKind;
    protected boolean nonMandatorySchemas = false;

    SearchSupport(AnyTypeKind anyTypeKind) {
        this.anyTypeKind = anyTypeKind;
    }

    public String fieldName(AttrSchemaType attrSchemaType) {
        String result;
        switch (attrSchemaType) {
            case Boolean: {
                result = "booleanvalue";
                break;
            }
            case Date: {
                result = "datevalue";
                break;
            }
            case Double: {
                result = "doublevalue";
                break;
            }
            case Long: {
                result = "longvalue";
                break;
            }
            case String: 
            case Enum: {
                result = "stringvalue";
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public SearchView field() {
        String result = "";
        switch (this.anyTypeKind) {
            case ANY_OBJECT: {
                result = "anyObject_search";
                break;
            }
            case GROUP: {
                result = "group_search";
                break;
            }
            default: {
                result = "user_search";
            }
        }
        return new SearchView("sv", result);
    }

    public SearchView attr() {
        return new SearchView("sva", this.field().name + "_attr");
    }

    public SearchView relationship() {
        String kind = this.anyTypeKind == AnyTypeKind.USER ? "u" : "a";
        return new SearchView("sv" + kind + "m", this.field().name + "_" + kind + "relationship");
    }

    public SearchView membership() {
        String kind = this.anyTypeKind == AnyTypeKind.USER ? "u" : "a";
        return new SearchView("sv" + kind + "m", this.field().name + "_" + kind + "membership");
    }

    public SearchView dyngroupmembership() {
        return new SearchView("sv" + this.anyTypeKind.name() + "dgm", this.anyTypeKind == AnyTypeKind.USER ? "UDynGroupMembers" : "ADynGroupMembers");
    }

    public SearchView role() {
        return new SearchView("svr", this.field().name + "_role");
    }

    public SearchView dynrolemembership() {
        return new SearchView("svdr", "DynRoleMembers");
    }

    public SearchView dynrealmmembership() {
        return new SearchView("svdrealm", "DynRealmMembers");
    }

    public SearchView nullAttr() {
        return new SearchView("svna", this.field().name + "_null_attr");
    }

    public SearchView resource() {
        return new SearchView("svr", this.field().name + "_resource");
    }

    public SearchView groupResource() {
        return new SearchView("svrr", this.field().name + "_group_res");
    }

    public SearchView uniqueAttr() {
        return new SearchView("svua", this.field().name + "_unique_attr");
    }

    public SearchView entitlements() {
        return new SearchView("sve", this.field().name + "_entitlements");
    }

    static class SearchView {
        protected String alias;
        protected String name;

        protected SearchView(String alias, String name) {
            this.alias = alias;
            this.name = name;
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }
    }
}

