/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Collections;
import java.util.List;
import javax.persistence.Query;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.task.AbstractTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPANotificationTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPropagationTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPullTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAPushTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPASchedTask;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

@Repository
public class JPATaskDAO
extends AbstractDAO<Task>
implements TaskDAO {
    public Class<? extends Task> getEntityReference(TaskType type) {
        Class result = null;
        switch (type) {
            case NOTIFICATION: {
                result = JPANotificationTask.class;
                break;
            }
            case PROPAGATION: {
                result = JPAPropagationTask.class;
                break;
            }
            case PUSH: {
                result = JPAPushTask.class;
                break;
            }
            case SCHEDULED: {
                result = JPASchedTask.class;
                break;
            }
            case PULL: {
                result = JPAPullTask.class;
                break;
            }
        }
        return result;
    }

    @Transactional(readOnly=true)
    public <T extends Task> T find(String key) {
        return (T)((Task)this.entityManager().find(AbstractTask.class, (Object)key));
    }

    private <T extends Task> StringBuilder buildFindAllQuery(TaskType type) {
        StringBuilder builder = new StringBuilder("SELECT t FROM ").append(this.getEntityReference(type).getSimpleName()).append(" t WHERE ");
        if (type == TaskType.SCHEDULED) {
            builder.append("t.id NOT IN (SELECT t.id FROM ").append(JPAPushTask.class.getSimpleName()).append(" t) ").append("AND ").append("t.id NOT IN (SELECT t.id FROM ").append(JPAPullTask.class.getSimpleName()).append(" t)");
        } else {
            builder.append("1=1");
        }
        return builder.append(' ');
    }

    public <T extends Task> List<T> findToExec(TaskType type) {
        StringBuilder queryString = this.buildFindAllQuery(type).append("AND ");
        if (type == TaskType.NOTIFICATION) {
            queryString.append("t.executed = 0 ");
        } else {
            queryString.append("t.executions IS EMPTY ");
        }
        queryString.append("ORDER BY t.id DESC");
        Query query = this.entityManager().createQuery(queryString.toString());
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public <T extends Task> List<T> findAll(TaskType type) {
        return this.findAll(type, null, null, null, null, -1, -1, Collections.emptyList());
    }

    private StringBuilder buildFindAllQuery(TaskType type, ExternalResource resource, Notification notification, AnyTypeKind anyTypeKind, String entityKey) {
        if (resource != null && type != TaskType.PROPAGATION && type != TaskType.PUSH && type != TaskType.PULL) {
            throw new IllegalArgumentException(type + " is not related to " + ExternalResource.class.getSimpleName());
        }
        if ((anyTypeKind != null || entityKey != null) && type != TaskType.PROPAGATION && type != TaskType.NOTIFICATION) {
            throw new IllegalArgumentException(type + " is not related to users, groups or any objects");
        }
        if (notification != null && type != TaskType.NOTIFICATION) {
            throw new IllegalArgumentException(type + " is not related to notifications");
        }
        StringBuilder queryString = this.buildFindAllQuery(type);
        if (resource != null) {
            queryString.append("AND t.resource=:resource ");
        }
        if (notification != null) {
            queryString.append("AND t.notification=:notification ");
        }
        if (anyTypeKind != null && entityKey != null) {
            queryString.append("AND t.anyTypeKind=:anyTypeKind AND t.entityKey=:entityKey ");
        }
        return queryString;
    }

    private String toOrderByStatement(Class<? extends Task> beanClass, List<OrderByClause> orderByClauses) {
        StringBuilder statement = new StringBuilder();
        for (OrderByClause clause : orderByClauses) {
            String field = clause.getField().trim();
            if (ReflectionUtils.findField(beanClass, (String)field) == null) continue;
            statement.append("t.").append(field).append(' ').append(clause.getDirection().name());
        }
        if (statement.length() == 0) {
            statement.append("ORDER BY t.id DESC");
        } else {
            statement.insert(0, "ORDER BY ");
        }
        return statement.toString();
    }

    public <T extends Task> List<T> findAll(TaskType type, ExternalResource resource, Notification notification, AnyTypeKind anyTypeKind, String entityKey, int page, int itemsPerPage, List<OrderByClause> orderByClauses) {
        StringBuilder queryString = this.buildFindAllQuery(type, resource, notification, anyTypeKind, entityKey).append(this.toOrderByStatement(this.getEntityReference(type), orderByClauses));
        Query query = this.entityManager().createQuery(queryString.toString());
        if (resource != null) {
            query.setParameter("resource", (Object)resource);
        }
        if (notification != null) {
            query.setParameter("notification", (Object)notification);
        }
        if (anyTypeKind != null && entityKey != null) {
            query.setParameter("anyTypeKind", (Object)anyTypeKind);
            query.setParameter("entityKey", (Object)entityKey);
        }
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage > 0) {
            query.setMaxResults(itemsPerPage);
        }
        return query.getResultList();
    }

    public int count(TaskType type, ExternalResource resource, Notification notification, AnyTypeKind anyTypeKind, String entityKey) {
        StringBuilder queryString = this.buildFindAllQuery(type, resource, notification, anyTypeKind, entityKey);
        Query query = this.entityManager().createQuery(StringUtils.replaceOnce((String)queryString.toString(), (String)"SELECT t", (String)"SELECT COUNT(t)"));
        if (resource != null) {
            query.setParameter("resource", (Object)resource);
        }
        if (notification != null) {
            query.setParameter("notification", (Object)notification);
        }
        if (anyTypeKind != null && entityKey != null) {
            query.setParameter("anyTypeKind", (Object)anyTypeKind);
            query.setParameter("entityKey", (Object)entityKey);
        }
        return ((Number)query.getSingleResult()).intValue();
    }

    @Transactional(rollbackFor={Throwable.class})
    public <T extends Task> T save(T task) {
        return (T)((Task)this.entityManager().merge(task));
    }

    public void delete(String id) {
        Object task = this.find(id);
        if (task == null) {
            return;
        }
        this.delete((Task)task);
    }

    public void delete(Task task) {
        this.entityManager().remove((Object)task);
    }

    public void deleteAll(ExternalResource resource, TaskType type) {
        IterableUtils.forEach(this.findAll(type, resource, null, null, null, -1, -1, Collections.emptyList()), (Closure)new Closure<Task>(){

            public void execute(Task input) {
                JPATaskDAO.this.delete(input.getKey());
            }
        });
    }
}

