/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPARole;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUser;
import org.apache.syncope.core.provisioning.api.event.AnyCreatedUpdatedEvent;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JPARoleDAO
extends AbstractDAO<Role>
implements RoleDAO {
    public static final String DYNMEMB_TABLE = "DynRoleMembers";
    @Autowired
    private ApplicationEventPublisher publisher;
    private AnySearchDAO searchDAO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnySearchDAO searchDAO() {
        JPARoleDAO jPARoleDAO = this;
        synchronized (jPARoleDAO) {
            if (this.searchDAO == null) {
                this.searchDAO = (AnySearchDAO)ApplicationContextProvider.getApplicationContext().getBean(AnySearchDAO.class);
            }
        }
        return this.searchDAO;
    }

    public int count() {
        Query query = this.entityManager().createQuery("SELECT COUNT(e) FROM  " + JPARole.class.getSimpleName() + " e");
        return ((Number)query.getSingleResult()).intValue();
    }

    public Role find(String key) {
        return (Role)this.entityManager().find(JPARole.class, (Object)key);
    }

    public List<Role> findByRealm(Realm realm) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARole.class.getSimpleName() + " e WHERE :realm MEMBER OF e.realms", Role.class);
        query.setParameter("realm", (Object)realm);
        return query.getResultList();
    }

    public List<Role> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPARole.class.getSimpleName() + " e ", Role.class);
        return query.getResultList();
    }

    public Role save(Role role) {
        Role merged = (Role)this.entityManager().merge((Object)role);
        if (merged.getDynMembership() != null) {
            List matching = this.searchDAO().search(SearchCondConverter.convert((String)merged.getDynMembership().getFIQLCond(), (String[])new String[0]), AnyTypeKind.USER);
            this.clearDynMembers(merged);
            for (User user : matching) {
                Query insert = this.entityManager().createNativeQuery("INSERT INTO DynRoleMembers VALUES(?, ?)");
                insert.setParameter(1, (Object)user.getKey());
                insert.setParameter(2, (Object)merged.getKey());
                insert.executeUpdate();
                this.publisher.publishEvent((ApplicationEvent)new AnyCreatedUpdatedEvent((Object)this, (Any)user, AuthContextUtils.getDomain()));
            }
        }
        return merged;
    }

    public void delete(Role role) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAUser.class.getSimpleName() + " e WHERE :role MEMBER OF e.roles", User.class);
        query.setParameter("role", (Object)role);
        for (User user : query.getResultList()) {
            user.getRoles().remove(role);
            this.publisher.publishEvent((ApplicationEvent)new AnyCreatedUpdatedEvent((Object)this, (Any)user, AuthContextUtils.getDomain()));
        }
        this.clearDynMembers(role);
        this.entityManager().remove((Object)role);
    }

    public void delete(String key) {
        Role role = this.find(key);
        if (role == null) {
            return;
        }
        this.delete(role);
    }

    public List<String> findDynMembers(Role role) {
        if (role.getDynMembership() == null) {
            return Collections.emptyList();
        }
        Query query = this.entityManager().createNativeQuery("SELECT any_id FROM DynRoleMembers WHERE role_id=?");
        query.setParameter(1, (Object)role.getKey());
        ArrayList<String> result = new ArrayList<String>();
        for (Object key : query.getResultList()) {
            String actualKey = key instanceof Object[] ? (String)((Object[])key)[0] : (String)key;
            result.add(actualKey);
        }
        return result;
    }

    public void clearDynMembers(Role role) {
        Query delete = this.entityManager().createNativeQuery("DELETE FROM DynRoleMembers WHERE role_id=?");
        delete.setParameter(1, (Object)role.getKey());
        delete.executeUpdate();
    }

    @Transactional
    public void refreshDynMemberships(User user) {
        for (Role role : this.findAll()) {
            if (role.getDynMembership() == null) continue;
            Query delete = this.entityManager().createNativeQuery("DELETE FROM DynRoleMembers WHERE role_id=? AND any_id=?");
            delete.setParameter(1, (Object)role.getKey());
            delete.setParameter(2, (Object)user.getKey());
            delete.executeUpdate();
            if (!this.searchDAO().matches((Any)user, SearchCondConverter.convert((String)role.getDynMembership().getFIQLCond(), (String[])new String[0]))) continue;
            Query insert = this.entityManager().createNativeQuery("INSERT INTO DynRoleMembers VALUES(?, ?)");
            insert.setParameter(1, (Object)user.getKey());
            insert.setParameter(2, (Object)role.getKey());
            insert.executeUpdate();
        }
    }

    public void removeDynMemberships(String key) {
        Query delete = this.entityManager().createNativeQuery("DELETE FROM DynRoleMembers WHERE any_id=?");
        delete.setParameter(1, (Object)key);
        delete.executeUpdate();
    }
}

