/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.ReportExecDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportExec;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAReportExec;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

@Repository
public class JPAReportExecDAO
extends AbstractDAO<ReportExec>
implements ReportExecDAO {
    public ReportExec find(String key) {
        return (ReportExec)this.entityManager().find(JPAReportExec.class, (Object)key);
    }

    public List<ReportExec> findRecent(int max) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAReportExec.class.getSimpleName() + " e WHERE e.end IS NOT NULL ORDER BY e.end DESC", ReportExec.class);
        query.setMaxResults(max);
        return query.getResultList();
    }

    private ReportExec findLatest(Report report, String field) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAReportExec.class.getSimpleName() + " e WHERE e.report=:report ORDER BY e." + field + " DESC", ReportExec.class);
        query.setParameter("report", (Object)report);
        query.setMaxResults(1);
        List result = query.getResultList();
        return result == null || result.isEmpty() ? null : (ReportExec)result.iterator().next();
    }

    public ReportExec findLatestStarted(Report report) {
        return this.findLatest(report, "start");
    }

    public ReportExec findLatestEnded(Report report) {
        return this.findLatest(report, "end");
    }

    public int count(String reportKey) {
        Query countQuery = this.entityManager().createNativeQuery("SELECT COUNT(e.id) FROM ReportExec e WHERE e.report_id=?1");
        countQuery.setParameter(1, (Object)reportKey);
        return ((Number)countQuery.getSingleResult()).intValue();
    }

    private String toOrderByStatement(List<OrderByClause> orderByClauses) {
        StringBuilder statement = new StringBuilder();
        for (OrderByClause clause : orderByClauses) {
            String field = clause.getField().trim();
            if (ReflectionUtils.findField(JPAReportExec.class, (String)field) == null) continue;
            statement.append("e.").append(field).append(' ').append(clause.getDirection().name());
        }
        if (statement.length() == 0) {
            statement.append("ORDER BY e.id DESC");
        } else {
            statement.insert(0, "ORDER BY ");
        }
        return statement.toString();
    }

    public List<ReportExec> findAll(Report report, int page, int itemsPerPage, List<OrderByClause> orderByClauses) {
        String queryString = "SELECT e FROM " + JPAReportExec.class.getSimpleName() + " e WHERE e.report=:report " + this.toOrderByStatement(orderByClauses);
        TypedQuery query = this.entityManager().createQuery(queryString, ReportExec.class);
        query.setParameter("report", (Object)report);
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        if (itemsPerPage >= 0) {
            query.setMaxResults(itemsPerPage);
        }
        return query.getResultList();
    }

    public List<ReportExec> findAll(Report report, Date startedBefore, Date startedAfter, Date endedBefore, Date endedAfter) {
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(JPAReportExec.class.getSimpleName()).append(" e WHERE e.report=:report ");
        if (startedBefore != null) {
            queryString.append(" AND e.start < :startedBefore");
        }
        if (startedAfter != null) {
            queryString.append(" AND e.start > :startedAfter");
        }
        if (endedBefore != null) {
            queryString.append(" AND e.end < :endedBefore");
        }
        if (endedAfter != null) {
            queryString.append(" AND e.end > :endedAfter");
        }
        TypedQuery query = this.entityManager().createQuery(queryString.toString(), ReportExec.class);
        query.setParameter("report", (Object)report);
        if (startedBefore != null) {
            query.setParameter("startedBefore", (Object)startedBefore);
        }
        if (startedAfter != null) {
            query.setParameter("startedAfter", (Object)startedAfter);
        }
        if (endedBefore != null) {
            query.setParameter("endedBefore", (Object)endedBefore);
        }
        if (endedAfter != null) {
            query.setParameter("endedAfter", (Object)endedAfter);
        }
        return query.getResultList();
    }

    @Transactional(rollbackFor={Throwable.class})
    public ReportExec save(ReportExec execution) {
        return (ReportExec)this.entityManager().merge((Object)execution);
    }

    public void delete(String key) {
        ReportExec execution = this.find(key);
        if (execution == null) {
            return;
        }
        this.delete(execution);
    }

    public void delete(ReportExec execution) {
        if (execution.getReport() != null) {
            execution.getReport().getExecs().remove(execution);
        }
        this.entityManager().remove((Object)execution);
    }
}

