/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportTemplate;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAReport;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JPAReportDAO
extends AbstractDAO<Report>
implements ReportDAO {
    @Transactional(readOnly=true)
    public Report find(String key) {
        return (Report)this.entityManager().find(JPAReport.class, (Object)key);
    }

    @Transactional(readOnly=true)
    public List<Report> findByTemplate(ReportTemplate template) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAReport.class.getSimpleName() + " e WHERE e.template=:template", Report.class);
        query.setParameter("template", (Object)template);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<Report> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAReport.class.getSimpleName() + " e", Report.class);
        return query.getResultList();
    }

    @Transactional(rollbackFor={Throwable.class})
    public Report save(Report report) {
        return (Report)this.entityManager().merge((Object)report);
    }

    public void delete(String key) {
        Report report = this.find(key);
        if (report == null) {
            return;
        }
        this.delete(report);
    }

    public void delete(Report report) {
        this.entityManager().remove((Object)report);
    }
}

