/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PullPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PushPolicy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.policy.AbstractPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAAccountPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPasswordPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPullPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPushPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JPAPolicyDAO
extends AbstractDAO<Policy>
implements PolicyDAO {
    @Autowired
    private RealmDAO realmDAO;

    private <T extends Policy> Class<? extends AbstractPolicy> getEntityReference(Class<T> reference) {
        return AccountPolicy.class.isAssignableFrom(reference) ? JPAAccountPolicy.class : (PasswordPolicy.class.isAssignableFrom(reference) ? JPAPasswordPolicy.class : (PullPolicy.class.isAssignableFrom(reference) ? JPAPullPolicy.class : (PushPolicy.class.isAssignableFrom(reference) ? JPAPushPolicy.class : null)));
    }

    public <T extends Policy> T find(String key) {
        return (T)((Policy)this.entityManager().find(AbstractPolicy.class, (Object)key));
    }

    public <T extends Policy> List<T> find(Class<T> reference) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + this.getEntityReference(reference).getSimpleName() + " e", reference);
        return query.getResultList();
    }

    public List<AccountPolicy> findByResource(ExternalResource resource) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAAccountPolicy.class.getSimpleName() + " e WHERE :resource MEMBER OF e.resources", AccountPolicy.class);
        query.setParameter("resource", (Object)resource);
        return query.getResultList();
    }

    public List<Policy> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + AbstractPolicy.class.getSimpleName() + " e", Policy.class);
        return query.getResultList();
    }

    public <T extends Policy> T save(T policy) {
        return (T)((Policy)this.entityManager().merge(policy));
    }

    public <T extends Policy> void delete(T policy) {
        for (Realm realm : this.realmDAO.findByPolicy(policy)) {
            if (policy instanceof AccountPolicy) {
                realm.setAccountPolicy(null);
                continue;
            }
            if (!(policy instanceof PasswordPolicy)) continue;
            realm.setPasswordPolicy(null);
        }
        this.entityManager().remove(policy);
    }
}

