/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AssignableCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.GroupablePlainAttr;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.ADynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.AMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.APlainAttr;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.TypeExtension;
import org.apache.syncope.core.persistence.api.entity.user.UDynGroupMembership;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.jpa.dao.AbstractAnyDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyUtilsFactory;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAADynGroupMembership;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAMembership;
import org.apache.syncope.core.persistence.jpa.entity.group.JPAGroup;
import org.apache.syncope.core.persistence.jpa.entity.group.JPATypeExtension;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUDynGroupMembership;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUMembership;
import org.apache.syncope.core.provisioning.api.event.AnyCreatedUpdatedEvent;
import org.apache.syncope.core.provisioning.api.event.AnyDeletedEvent;
import org.apache.syncope.core.provisioning.api.utils.EntityUtils;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JPAGroupDAO
extends AbstractAnyDAO<Group>
implements GroupDAO {
    public static final String UDYNMEMB_TABLE = "UDynGroupMembers";
    public static final String ADYNMEMB_TABLE = "ADynGroupMembers";
    @Autowired
    private PlainAttrDAO plainAttrDAO;
    private UserDAO userDAO;
    private AnyObjectDAO anyObjectDAO;
    private AnySearchDAO searchDAO;
    private AnySearchDAO jpaAnySearchDAO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserDAO userDAO() {
        JPAGroupDAO jPAGroupDAO = this;
        synchronized (jPAGroupDAO) {
            if (this.userDAO == null) {
                this.userDAO = (UserDAO)ApplicationContextProvider.getApplicationContext().getBean(UserDAO.class);
            }
        }
        return this.userDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnyObjectDAO anyObjectDAO() {
        JPAGroupDAO jPAGroupDAO = this;
        synchronized (jPAGroupDAO) {
            if (this.anyObjectDAO == null) {
                this.anyObjectDAO = (AnyObjectDAO)ApplicationContextProvider.getApplicationContext().getBean(AnyObjectDAO.class);
            }
        }
        return this.anyObjectDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnySearchDAO searchDAO() {
        JPAGroupDAO jPAGroupDAO = this;
        synchronized (jPAGroupDAO) {
            if (this.searchDAO == null) {
                this.searchDAO = (AnySearchDAO)ApplicationContextProvider.getApplicationContext().getBean(AnySearchDAO.class);
            }
        }
        return this.searchDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnySearchDAO jpaAnySearchDAO() {
        JPAGroupDAO jPAGroupDAO = this;
        synchronized (jPAGroupDAO) {
            if (this.jpaAnySearchDAO == null) {
                this.jpaAnySearchDAO = AopUtils.getTargetClass((Object)this.searchDAO()).equals(JPAAnySearchDAO.class) ? this.searchDAO() : (AnySearchDAO)ApplicationContextProvider.getBeanFactory().createBean(JPAAnySearchDAO.class, 2, true);
            }
        }
        return this.jpaAnySearchDAO;
    }

    @Override
    protected AnyUtils init() {
        return new JPAAnyUtilsFactory().getInstance(AnyTypeKind.GROUP);
    }

    @Transactional(readOnly=true)
    public String findKey(String username) {
        return this.findKey(username, "SyncopeGroup");
    }

    @Transactional(readOnly=true)
    public Date findLastChange(String key) {
        return this.findLastChange(key, "SyncopeGroup");
    }

    public int count() {
        Query query = this.entityManager().createQuery("SELECT COUNT(e) FROM  " + JPAGroup.class.getSimpleName() + " e");
        return ((Number)query.getSingleResult()).intValue();
    }

    public Map<String, Integer> countByRealm() {
        Query query = this.entityManager().createQuery("SELECT e.realm, COUNT(e) FROM  " + JPAGroup.class.getSimpleName() + " e GROUP BY e.realm");
        List results = query.getResultList();
        HashMap<String, Integer> countByRealm = new HashMap<String, Integer>(results.size());
        for (Object[] result : results) {
            countByRealm.put(((Realm)result[0]).getFullPath(), ((Number)result[1]).intValue());
        }
        return Collections.unmodifiableMap(countByRealm);
    }

    @Override
    protected void securityChecks(final Group group) {
        Set authRealms = SetUtils.emptyIfNull((Set)((Set)AuthContextUtils.getAuthorizations().get("GROUP_READ")));
        boolean authorized = IterableUtils.matchesAny((Iterable)authRealms, (Predicate)new Predicate<String>(){

            public boolean evaluate(String realm) {
                return group.getRealm().getFullPath().startsWith(realm) || realm.equals(RealmUtils.getGroupOwnerRealm((String)group.getRealm().getFullPath(), (String)group.getKey()));
            }
        });
        if (!authorized) {
            boolean bl = authorized = !CollectionUtils.intersection(this.findDynRealms(group.getKey()), (Iterable)authRealms).isEmpty();
        }
        if (authRealms.isEmpty() || !authorized) {
            throw new DelegatedAdministrationException(group.getRealm().getFullPath(), AnyTypeKind.GROUP.name(), group.getKey());
        }
    }

    public Group findByName(String name) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAGroup.class.getSimpleName() + " e WHERE e.name = :name", Group.class);
        query.setParameter("name", (Object)name);
        Group result = null;
        try {
            result = (Group)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("No group found with name {}", (Object)name, (Object)e);
        }
        return result;
    }

    @Transactional(readOnly=true)
    public List<Group> findOwnedByUser(String userKey) {
        User owner = (User)this.userDAO().find(userKey);
        if (owner == null) {
            return Collections.emptyList();
        }
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(JPAGroup.class.getSimpleName()).append(" e WHERE e.userOwner=:owner ");
        for (String groupKey : this.userDAO().findAllGroupKeys(owner)) {
            queryString.append("OR e.groupOwner.id='").append(groupKey).append("' ");
        }
        TypedQuery query = this.entityManager().createQuery(queryString.toString(), Group.class);
        query.setParameter("owner", (Object)owner);
        return query.getResultList();
    }

    @Transactional(readOnly=true)
    public List<Group> findOwnedByGroup(String groupKey) {
        Group owner = (Group)this.find(groupKey);
        if (owner == null) {
            return Collections.emptyList();
        }
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAGroup.class.getSimpleName() + " e WHERE e.groupOwner=:owner", Group.class);
        query.setParameter("owner", (Object)owner);
        return query.getResultList();
    }

    public List<AMembership> findAMemberships(Group group) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAAMembership.class.getSimpleName() + " e WHERE e.rightEnd=:group", AMembership.class);
        query.setParameter("group", (Object)group);
        return query.getResultList();
    }

    public List<UMembership> findUMemberships(Group group) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAUMembership.class.getSimpleName() + " e WHERE e.rightEnd=:group", UMembership.class);
        query.setParameter("group", (Object)group);
        return query.getResultList();
    }

    public List<Group> findAll(int page, int itemsPerPage) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM  " + JPAGroup.class.getSimpleName() + " e ORDER BY e.id", Group.class);
        query.setFirstResult(itemsPerPage * (page <= 0 ? 0 : page - 1));
        query.setMaxResults(itemsPerPage);
        return query.getResultList();
    }

    private SearchCond buildDynMembershipCond(String baseCondFIQL, Realm groupRealm) {
        AssignableCond cond = new AssignableCond();
        cond.setRealmFullPath(groupRealm.getFullPath());
        cond.setFromGroup(true);
        return SearchCond.getAndCond((SearchCond)SearchCond.getLeafCond((AssignableCond)cond), (SearchCond)SearchCondConverter.convert((String)baseCondFIQL, (String[])new String[0]));
    }

    @Override
    public Group save(Group group) {
        Group merged = super.save(group);
        this.publisher.publishEvent((ApplicationEvent)new AnyCreatedUpdatedEvent((Object)this, (Any)merged, AuthContextUtils.getDomain()));
        this.clearUDynMembers(merged);
        if (merged.getUDynMembership() != null) {
            SearchCond cond = this.buildDynMembershipCond(merged.getUDynMembership().getFIQLCond(), merged.getRealm());
            int count = this.searchDAO().count(Collections.singleton(merged.getRealm().getFullPath()), cond, AnyTypeKind.USER);
            for (int page = 1; page <= count / 500 + 1; ++page) {
                List matching = this.searchDAO().search(Collections.singleton(merged.getRealm().getFullPath()), cond, page, 500, Collections.emptyList(), AnyTypeKind.USER);
                for (User user : matching) {
                    Query insert = this.entityManager().createNativeQuery("INSERT INTO UDynGroupMembers VALUES(?, ?)");
                    insert.setParameter(1, (Object)user.getKey());
                    insert.setParameter(2, (Object)merged.getKey());
                    insert.executeUpdate();
                    this.publisher.publishEvent((ApplicationEvent)new AnyCreatedUpdatedEvent((Object)this, (Any)user, AuthContextUtils.getDomain()));
                }
            }
        }
        this.clearADynMembers(merged);
        for (ADynGroupMembership memb : merged.getADynMemberships()) {
            SearchCond cond = this.buildDynMembershipCond(memb.getFIQLCond(), merged.getRealm());
            int count = this.searchDAO().count(Collections.singleton(merged.getRealm().getFullPath()), cond, AnyTypeKind.ANY_OBJECT);
            for (int page = 1; page <= count / 500 + 1; ++page) {
                List matching = this.searchDAO().search(Collections.singleton(merged.getRealm().getFullPath()), cond, page, 500, Collections.emptyList(), AnyTypeKind.ANY_OBJECT);
                for (AnyObject anyObject : matching) {
                    Query insert = this.entityManager().createNativeQuery("INSERT INTO ADynGroupMembers VALUES(?, ?, ?)");
                    insert.setParameter(1, (Object)anyObject.getType().getKey());
                    insert.setParameter(2, (Object)anyObject.getKey());
                    insert.setParameter(3, (Object)merged.getKey());
                    insert.executeUpdate();
                    this.publisher.publishEvent((ApplicationEvent)new AnyCreatedUpdatedEvent((Object)this, (Any)anyObject, AuthContextUtils.getDomain()));
                }
            }
        }
        this.dynRealmDAO().refreshDynMemberships((Any)merged);
        return merged;
    }

    public void delete(Group group) {
        AnyObject leftEnd;
        this.dynRealmDAO().removeDynMemberships(group.getKey());
        for (AMembership aMembership : this.findAMemberships(group)) {
            leftEnd = (AnyObject)aMembership.getLeftEnd();
            leftEnd.getMemberships().remove(aMembership);
            aMembership.setRightEnd(null);
            for (APlainAttr attr : leftEnd.getPlainAttrs((Membership)aMembership)) {
                leftEnd.remove((GroupablePlainAttr)attr);
                attr.setOwner(null);
                attr.setMembership(null);
                this.plainAttrDAO.delete((PlainAttr)attr);
            }
            this.anyObjectDAO().save((Any)leftEnd);
            this.publisher.publishEvent((ApplicationEvent)new AnyCreatedUpdatedEvent((Object)this, (Any)leftEnd, AuthContextUtils.getDomain()));
        }
        for (UMembership uMembership : this.findUMemberships(group)) {
            leftEnd = (User)uMembership.getLeftEnd();
            leftEnd.getMemberships().remove(uMembership);
            uMembership.setRightEnd(null);
            for (APlainAttr attr : leftEnd.getPlainAttrs((Membership)uMembership)) {
                leftEnd.remove((GroupablePlainAttr)attr);
                attr.setOwner(null);
                attr.setMembership(null);
                this.plainAttrDAO.delete((PlainAttr)attr);
            }
            this.userDAO().save((Any)leftEnd);
            this.publisher.publishEvent((ApplicationEvent)new AnyCreatedUpdatedEvent((Object)this, (Any)leftEnd, AuthContextUtils.getDomain()));
        }
        this.clearUDynMembers(group);
        this.clearADynMembers(group);
        this.entityManager().remove((Object)group);
        this.publisher.publishEvent((ApplicationEvent)new AnyDeletedEvent((Object)this, AnyTypeKind.GROUP, group.getKey(), AuthContextUtils.getDomain()));
    }

    public List<TypeExtension> findTypeExtensions(AnyTypeClass anyTypeClass) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPATypeExtension.class.getSimpleName() + " e WHERE :anyTypeClass MEMBER OF e.auxClasses", TypeExtension.class);
        query.setParameter("anyTypeClass", (Object)anyTypeClass);
        return query.getResultList();
    }

    public List<String> findADynMembers(Group group) {
        ArrayList<String> result = new ArrayList<String>();
        for (ADynGroupMembership memb : group.getADynMemberships()) {
            Query query = this.entityManager().createNativeQuery("SELECT any_id FROM ADynGroupMembers WHERE group_id=? AND anyType_id=?");
            query.setParameter(1, (Object)group.getKey());
            query.setParameter(2, (Object)memb.getAnyType().getKey());
            for (Object key : query.getResultList()) {
                String actualKey = key instanceof Object[] ? (String)((Object[])key)[0] : (String)key;
                result.add(actualKey);
            }
        }
        return result;
    }

    public int countAMembers(Group group) {
        Query query = this.entityManager().createNativeQuery("SELECT COUNT(anyObject_id) FROM AMembership WHERE group_id=?");
        query.setParameter(1, (Object)group.getKey());
        return ((Number)query.getSingleResult()).intValue();
    }

    public int countUMembers(Group group) {
        Query query = this.entityManager().createNativeQuery("SELECT COUNT(user_id) FROM UMembership WHERE group_id=?");
        query.setParameter(1, (Object)group.getKey());
        return ((Number)query.getSingleResult()).intValue();
    }

    public int countADynMembers(Group group) {
        Query query = this.entityManager().createNativeQuery("SELECT COUNT(any_id) FROM ADynGroupMembers WHERE group_id=?");
        query.setParameter(1, (Object)group.getKey());
        return ((Number)query.getSingleResult()).intValue();
    }

    public int countUDynMembers(Group group) {
        if (group.getUDynMembership() == null) {
            return 0;
        }
        Query query = this.entityManager().createNativeQuery("SELECT COUNT(any_id) FROM UDynGroupMembers WHERE group_id=?");
        query.setParameter(1, (Object)group.getKey());
        return ((Number)query.getSingleResult()).intValue();
    }

    public void clearADynMembers(Group group) {
        Query delete = this.entityManager().createNativeQuery("DELETE FROM ADynGroupMembers WHERE group_id=?");
        delete.setParameter(1, (Object)group.getKey());
        delete.executeUpdate();
    }

    private List<ADynGroupMembership> findWithADynMemberships(AnyType anyType) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAADynGroupMembership.class.getSimpleName() + " e  WHERE e.anyType=:anyType", ADynGroupMembership.class);
        query.setParameter("anyType", (Object)anyType);
        return query.getResultList();
    }

    @Transactional
    public Pair<Set<String>, Set<String>> refreshDynMemberships(AnyObject anyObject) {
        HashSet<String> before = new HashSet<String>();
        HashSet<String> after = new HashSet<String>();
        for (ADynGroupMembership memb : this.findWithADynMemberships(anyObject.getType())) {
            Query delete = this.entityManager().createNativeQuery("DELETE FROM ADynGroupMembers WHERE group_id=? AND any_id=?");
            delete.setParameter(1, (Object)memb.getGroup().getKey());
            delete.setParameter(2, (Object)anyObject.getKey());
            if (delete.executeUpdate() > 0) {
                before.add(memb.getGroup().getKey());
            }
            if (this.jpaAnySearchDAO().matches((Any)anyObject, this.buildDynMembershipCond(memb.getFIQLCond(), memb.getGroup().getRealm()))) {
                Query insert = this.entityManager().createNativeQuery("INSERT INTO ADynGroupMembers VALUES(?, ?, ?)");
                insert.setParameter(1, (Object)anyObject.getType().getKey());
                insert.setParameter(2, (Object)anyObject.getKey());
                insert.setParameter(3, (Object)memb.getGroup().getKey());
                insert.executeUpdate();
                after.add(memb.getGroup().getKey());
            }
            this.publisher.publishEvent((ApplicationEvent)new AnyCreatedUpdatedEvent((Object)this, (Any)memb.getGroup(), AuthContextUtils.getDomain()));
        }
        return Pair.of(before, after);
    }

    public Set<String> removeDynMemberships(AnyObject anyObject) {
        List dynGroups = this.anyObjectDAO().findDynGroups(anyObject.getKey());
        Query delete = this.entityManager().createNativeQuery("DELETE FROM ADynGroupMembers WHERE any_id=?");
        delete.setParameter(1, (Object)anyObject.getKey());
        delete.executeUpdate();
        HashSet<String> before = new HashSet<String>();
        for (Group group : dynGroups) {
            before.add(group.getKey());
            this.publisher.publishEvent((ApplicationEvent)new AnyCreatedUpdatedEvent((Object)this, (Any)group, AuthContextUtils.getDomain()));
        }
        return before;
    }

    public List<String> findUDynMembers(Group group) {
        if (group.getUDynMembership() == null) {
            return Collections.emptyList();
        }
        Query query = this.entityManager().createNativeQuery("SELECT any_id FROM UDynGroupMembers WHERE group_id=?");
        query.setParameter(1, (Object)group.getKey());
        ArrayList<String> result = new ArrayList<String>();
        for (Object key : query.getResultList()) {
            String actualKey = key instanceof Object[] ? (String)((Object[])key)[0] : (String)key;
            result.add(actualKey);
        }
        return result;
    }

    public void clearUDynMembers(Group group) {
        Query delete = this.entityManager().createNativeQuery("DELETE FROM UDynGroupMembers WHERE group_id=?");
        delete.setParameter(1, (Object)group.getKey());
        delete.executeUpdate();
    }

    private List<UDynGroupMembership> findWithUDynMemberships() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAUDynGroupMembership.class.getSimpleName() + " e", UDynGroupMembership.class);
        return query.getResultList();
    }

    @Transactional
    public Pair<Set<String>, Set<String>> refreshDynMemberships(User user) {
        HashSet<String> before = new HashSet<String>();
        HashSet<String> after = new HashSet<String>();
        for (UDynGroupMembership memb : this.findWithUDynMemberships()) {
            Query delete = this.entityManager().createNativeQuery("DELETE FROM UDynGroupMembers WHERE group_id=? AND any_id=?");
            delete.setParameter(1, (Object)memb.getGroup().getKey());
            delete.setParameter(2, (Object)user.getKey());
            if (delete.executeUpdate() > 0) {
                before.add(memb.getGroup().getKey());
            }
            if (this.jpaAnySearchDAO().matches((Any)user, this.buildDynMembershipCond(memb.getFIQLCond(), memb.getGroup().getRealm()))) {
                Query insert = this.entityManager().createNativeQuery("INSERT INTO UDynGroupMembers VALUES(?, ?)");
                insert.setParameter(1, (Object)user.getKey());
                insert.setParameter(2, (Object)memb.getGroup().getKey());
                insert.executeUpdate();
                after.add(memb.getGroup().getKey());
            }
            this.publisher.publishEvent((ApplicationEvent)new AnyCreatedUpdatedEvent((Object)this, (Any)memb.getGroup(), AuthContextUtils.getDomain()));
        }
        return Pair.of(before, after);
    }

    public Set<String> removeDynMemberships(User user) {
        List dynGroups = this.userDAO().findDynGroups(user.getKey());
        Query delete = this.entityManager().createNativeQuery("DELETE FROM UDynGroupMembers WHERE any_id=?");
        delete.setParameter(1, (Object)user.getKey());
        delete.executeUpdate();
        HashSet<String> before = new HashSet<String>();
        for (Group group : dynGroups) {
            before.add(group.getKey());
            this.publisher.publishEvent((ApplicationEvent)new AnyCreatedUpdatedEvent((Object)this, (Any)group, AuthContextUtils.getDomain()));
        }
        return before;
    }

    @Transactional(readOnly=true)
    public Collection<String> findAllResourceKeys(String key) {
        return CollectionUtils.collect((Iterable)((Group)this.find(key)).getResources(), (Transformer)EntityUtils.keyTransformer());
    }
}

