/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.persistence.api.entity.DynRealmMembership;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPADynRealm;
import org.apache.syncope.core.provisioning.api.event.AnyCreatedUpdatedEvent;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JPADynRealmDAO
extends AbstractDAO<DynRealm>
implements DynRealmDAO {
    public static final String DYNMEMB_TABLE = "DynRealmMembers";
    @Autowired
    private ApplicationEventPublisher publisher;
    private AnySearchDAO searchDAO;
    private AnySearchDAO jpaAnySearchDAO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnySearchDAO searchDAO() {
        JPADynRealmDAO jPADynRealmDAO = this;
        synchronized (jPADynRealmDAO) {
            if (this.searchDAO == null) {
                this.searchDAO = (AnySearchDAO)ApplicationContextProvider.getApplicationContext().getBean(AnySearchDAO.class);
            }
        }
        return this.searchDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnySearchDAO jpaAnySearchDAO() {
        JPADynRealmDAO jPADynRealmDAO = this;
        synchronized (jPADynRealmDAO) {
            if (this.jpaAnySearchDAO == null) {
                this.jpaAnySearchDAO = AopUtils.getTargetClass((Object)this.searchDAO()).equals(JPAAnySearchDAO.class) ? this.searchDAO() : (AnySearchDAO)ApplicationContextProvider.getBeanFactory().createBean(JPAAnySearchDAO.class, 2, true);
            }
        }
        return this.jpaAnySearchDAO;
    }

    public DynRealm find(String key) {
        return (DynRealm)this.entityManager().find(JPADynRealm.class, (Object)key);
    }

    public List<DynRealm> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPADynRealm.class.getSimpleName() + " e ", DynRealm.class);
        return query.getResultList();
    }

    public DynRealm save(DynRealm dynRealm) {
        DynRealm merged = (DynRealm)this.entityManager().merge((Object)dynRealm);
        this.clearDynMembers(merged);
        for (DynRealmMembership memb : merged.getDynMemberships()) {
            List matching = this.jpaAnySearchDAO().search(SearchCondConverter.convert((String)memb.getFIQLCond(), (String[])new String[0]), memb.getAnyType().getKind());
            for (Any any : matching) {
                Query insert = this.entityManager().createNativeQuery("INSERT INTO DynRealmMembers VALUES(?, ?)");
                insert.setParameter(1, (Object)any.getKey());
                insert.setParameter(2, (Object)merged.getKey());
                insert.executeUpdate();
                this.publisher.publishEvent((ApplicationEvent)new AnyCreatedUpdatedEvent((Object)this, any, AuthContextUtils.getDomain()));
            }
        }
        return merged;
    }

    public void delete(String key) {
        DynRealm dynRealm = this.find(key);
        if (dynRealm == null) {
            return;
        }
        this.clearDynMembers(dynRealm);
        this.entityManager().remove((Object)dynRealm);
    }

    public void clearDynMembers(DynRealm dynRealm) {
        Query delete = this.entityManager().createNativeQuery("DELETE FROM DynRealmMembers WHERE dynRealm_id=?");
        delete.setParameter(1, (Object)dynRealm.getKey());
        delete.executeUpdate();
    }

    @Transactional
    public void refreshDynMemberships(Any<?> any) {
        for (DynRealm dynRealm : this.findAll()) {
            DynRealmMembership memb = dynRealm.getDynMembership(any.getType());
            if (memb == null) continue;
            Query delete = this.entityManager().createNativeQuery("DELETE FROM DynRealmMembers WHERE dynRealm_id=? AND any_id=?");
            delete.setParameter(1, (Object)dynRealm.getKey());
            delete.setParameter(2, (Object)any.getKey());
            delete.executeUpdate();
            if (!this.jpaAnySearchDAO().matches(any, SearchCondConverter.convert((String)memb.getFIQLCond(), (String[])new String[0]))) continue;
            Query insert = this.entityManager().createNativeQuery("INSERT INTO DynRealmMembers VALUES(?, ?)");
            insert.setParameter(1, (Object)any.getKey());
            insert.setParameter(2, (Object)dynRealm.getKey());
            insert.executeUpdate();
        }
    }

    public void removeDynMemberships(String key) {
        Query delete = this.entityManager().createNativeQuery("DELETE FROM DynRealmMembers WHERE any_id=?");
        delete.setParameter(1, (Object)key);
        delete.executeUpdate();
    }
}

