/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.persistence.TypedQuery;
import org.apache.commons.collections4.Closure;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceHistoryConfDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAConnInstance;
import org.apache.syncope.core.provisioning.api.ConnectorRegistry;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JPAConnInstanceDAO
extends AbstractDAO<ConnInstance>
implements ConnInstanceDAO {
    @Autowired
    private ConnInstanceHistoryConfDAO connInstanceHistoryConfDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private ConnectorRegistry connRegistry;

    public ConnInstance find(String key) {
        return (ConnInstance)this.entityManager().find(JPAConnInstance.class, (Object)key);
    }

    public ConnInstance authFind(String key) {
        final ConnInstance connInstance = this.find(key);
        if (connInstance == null) {
            return null;
        }
        Set authRealms = (Set)AuthContextUtils.getAuthorizations().get("CONNECTOR_READ");
        if (authRealms == null || authRealms.isEmpty() || !IterableUtils.matchesAny((Iterable)authRealms, (Predicate)new Predicate<String>(){

            public boolean evaluate(String realm) {
                return connInstance.getAdminRealm().getFullPath().startsWith(realm);
            }
        })) {
            throw new DelegatedAdministrationException(connInstance.getAdminRealm().getFullPath(), ConnInstance.class.getSimpleName(), connInstance.getKey());
        }
        return connInstance;
    }

    public List<ConnInstance> findAll() {
        final Set authRealms = (Set)AuthContextUtils.getAuthorizations().get("CONNECTOR_LIST");
        if (authRealms == null || authRealms.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAConnInstance.class.getSimpleName() + " e", ConnInstance.class);
        return (List)CollectionUtils.select((Iterable)query.getResultList(), (Predicate)new Predicate<ConnInstance>(){

            public boolean evaluate(final ConnInstance connInstance) {
                return IterableUtils.matchesAny((Iterable)authRealms, (Predicate)new Predicate<String>(){

                    public boolean evaluate(String realm) {
                        return connInstance.getAdminRealm().getFullPath().startsWith(realm);
                    }
                });
            }
        }, new ArrayList());
    }

    public ConnInstance save(ConnInstance connector) {
        ConnInstance merged = (ConnInstance)this.entityManager().merge((Object)connector);
        for (ExternalResource resource : merged.getResources()) {
            try {
                this.connRegistry.registerConnector(resource);
            }
            catch (NotFoundException e) {
                LOG.error("While registering connector for resource", (Throwable)e);
            }
        }
        return merged;
    }

    public void delete(String key) {
        ConnInstance connInstance = this.find(key);
        if (connInstance == null) {
            return;
        }
        IterableUtils.forEach(new CopyOnWriteArrayList(connInstance.getResources()), (Closure)new Closure<ExternalResource>(){

            public void execute(ExternalResource input) {
                JPAConnInstanceDAO.this.resourceDAO.delete(input.getKey());
            }
        });
        this.connInstanceHistoryConfDAO.deleteByEntity(connInstance);
        this.entityManager().remove((Object)connInstance);
        this.connRegistry.unregisterConnector(key);
    }
}

