/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.policy.DefaultPasswordRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.core.persistence.api.dao.PasswordRule;
import org.apache.syncope.core.persistence.api.dao.PasswordRuleConfClass;
import org.apache.syncope.core.persistence.api.entity.GroupablePlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.utils.policy.PasswordPolicyException;
import org.apache.syncope.core.provisioning.api.utils.policy.PolicyPattern;
import org.springframework.transaction.annotation.Transactional;

@PasswordRuleConfClass(value=DefaultPasswordRuleConf.class)
public class DefaultPasswordRule
implements PasswordRule {
    private DefaultPasswordRuleConf conf;

    @Transactional(readOnly=true)
    public void enforce(PasswordRuleConf conf, User user) {
        if (!(conf instanceof DefaultPasswordRuleConf)) {
            throw new IllegalArgumentException(PasswordRuleConf.class.getName() + " expected, got " + conf.getClass().getName());
        }
        this.conf = (DefaultPasswordRuleConf)conf;
        for (String schema : this.conf.getSchemasNotPermitted()) {
            List values;
            GroupablePlainAttr attr = user.getPlainAttr(schema);
            if (attr == null || (values = attr.getValuesAsStrings()) == null || values.isEmpty()) continue;
            this.conf.getWordsNotPermitted().add(values.get(0));
        }
        String clearPassword = user.getClearPassword();
        String password = user.getPassword();
        if (password != null && clearPassword != null) {
            if (this.conf.getMinLength() > 0 && this.conf.getMinLength() > clearPassword.length()) {
                throw new PasswordPolicyException("Password too short");
            }
            if (this.conf.getMaxLength() > 0 && this.conf.getMaxLength() < clearPassword.length()) {
                throw new PasswordPolicyException("Password too long");
            }
            for (String word : this.conf.getWordsNotPermitted()) {
                if (!StringUtils.containsIgnoreCase((CharSequence)clearPassword, (CharSequence)word)) continue;
                throw new PasswordPolicyException("Used word(s) not permitted");
            }
            if (this.conf.isDigitRequired() && !this.checkDigit(clearPassword)) {
                throw new PasswordPolicyException("Password must contain digit(s)");
            }
            if (this.conf.isLowercaseRequired() && !this.checkLowercase(clearPassword)) {
                throw new PasswordPolicyException("Password must contain lowercase alphabetic character(s)");
            }
            if (this.conf.isUppercaseRequired() && !this.checkUppercase(clearPassword)) {
                throw new PasswordPolicyException("Password must contain uppercase alphabetic character(s)");
            }
            for (String prefix : this.conf.getPrefixesNotPermitted()) {
                if (!clearPassword.startsWith(prefix)) continue;
                throw new PasswordPolicyException("Prefix not permitted");
            }
            for (String suffix : this.conf.getSuffixesNotPermitted()) {
                if (!clearPassword.endsWith(suffix)) continue;
                throw new PasswordPolicyException("Suffix not permitted");
            }
            if (this.conf.isMustStartWithDigit() && !this.checkFirstDigit(clearPassword)) {
                throw new PasswordPolicyException("Password must start with a digit");
            }
            if (this.conf.isMustntStartWithDigit() && this.checkFirstDigit(clearPassword)) {
                throw new PasswordPolicyException("Password mustn't start with a digit");
            }
            if (this.conf.isMustEndWithDigit() && !this.checkLastDigit(clearPassword)) {
                throw new PasswordPolicyException("Password must end with a digit");
            }
            if (this.conf.isMustntEndWithDigit() && this.checkLastDigit(clearPassword)) {
                throw new PasswordPolicyException("Password mustn't end with a digit");
            }
            if (this.conf.isAlphanumericRequired() && !this.checkAlphanumeric(clearPassword)) {
                throw new PasswordPolicyException("Password must contain alphanumeric character(s)");
            }
            if (this.conf.isNonAlphanumericRequired() && !this.checkNonAlphanumeric(clearPassword)) {
                throw new PasswordPolicyException("Password must contain non-alphanumeric character(s)");
            }
            if (this.conf.isMustStartWithAlpha() && !this.checkFirstAlphanumeric(clearPassword)) {
                throw new PasswordPolicyException("Password must start with an alphanumeric character");
            }
            if (this.conf.isMustntStartWithAlpha() && this.checkFirstAlphanumeric(clearPassword)) {
                throw new PasswordPolicyException("Password mustn't start with an alphanumeric character");
            }
            if (this.conf.isMustEndWithAlpha() && !this.checkLastAlphanumeric(clearPassword)) {
                throw new PasswordPolicyException("Password must end with an alphanumeric character");
            }
            if (this.conf.isMustntEndWithAlpha() && this.checkLastAlphanumeric(clearPassword)) {
                throw new PasswordPolicyException("Password mustn't end with an alphanumeric character");
            }
            if (this.conf.isMustStartWithNonAlpha() && !this.checkFirstNonAlphanumeric(clearPassword)) {
                throw new PasswordPolicyException("Password must start with a non-alphanumeric character");
            }
            if (this.conf.isMustntStartWithNonAlpha() && this.checkFirstNonAlphanumeric(clearPassword)) {
                throw new PasswordPolicyException("Password mustn't start with a non-alphanumeric character");
            }
            if (this.conf.isMustEndWithNonAlpha() && !this.checkLastNonAlphanumeric(clearPassword)) {
                throw new PasswordPolicyException("Password must end with a non-alphanumeric character");
            }
            if (this.conf.isMustntEndWithNonAlpha() && this.checkLastNonAlphanumeric(clearPassword)) {
                throw new PasswordPolicyException("Password mustn't end with a non-alphanumeric character");
            }
            if (!this.conf.isUsernameAllowed() && user.getUsername() != null && user.getUsername().equals(clearPassword)) {
                throw new PasswordPolicyException("Password mustn't be equal to username");
            }
        }
    }

    private boolean checkDigit(String str) {
        return PolicyPattern.DIGIT.matcher(str).matches();
    }

    private boolean checkLowercase(String str) {
        return PolicyPattern.ALPHA_LOWERCASE.matcher(str).matches();
    }

    private boolean checkUppercase(String str) {
        return PolicyPattern.ALPHA_UPPERCASE.matcher(str).matches();
    }

    private boolean checkFirstDigit(String str) {
        return PolicyPattern.FIRST_DIGIT.matcher(str).matches();
    }

    private boolean checkLastDigit(String str) {
        return PolicyPattern.LAST_DIGIT.matcher(str).matches();
    }

    private boolean checkAlphanumeric(String str) {
        return PolicyPattern.ALPHANUMERIC.matcher(str).matches();
    }

    private boolean checkFirstAlphanumeric(String str) {
        return PolicyPattern.FIRST_ALPHANUMERIC.matcher(str).matches();
    }

    private boolean checkLastAlphanumeric(String str) {
        return PolicyPattern.LAST_ALPHANUMERIC.matcher(str).matches();
    }

    private boolean checkNonAlphanumeric(String str) {
        return PolicyPattern.NON_ALPHANUMERIC.matcher(str).matches();
    }

    private boolean checkFirstNonAlphanumeric(String str) {
        return PolicyPattern.FIRST_NON_ALPHANUMERIC.matcher(str).matches();
    }

    private boolean checkLastNonAlphanumeric(String str) {
        return PolicyPattern.LAST_NON_ALPHANUMERIC.matcher(str).matches();
    }
}

