/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.syncope.core.persistence.api.dao.DAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;

@Configurable
public abstract class AbstractDAO<E extends Entity>
implements DAO<E> {
    protected static final Logger LOG = LoggerFactory.getLogger(DAO.class);

    protected EntityManager entityManager() {
        EntityManager entityManager = EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)EntityManagerFactoryUtils.findEntityManagerFactory((ListableBeanFactory)ApplicationContextProvider.getBeanFactory(), (String)AuthContextUtils.getDomain()));
        if (entityManager == null) {
            throw new IllegalStateException("Could not find EntityManager for domain " + AuthContextUtils.getDomain());
        }
        return entityManager;
    }

    public void refresh(E entity) {
        this.entityManager().refresh(entity);
    }

    public void detach(E entity) {
        this.entityManager().detach(entity);
    }

    public void flush() {
        this.entityManager().flush();
    }

    public void clear() {
        this.entityManager().clear();
    }
}

