/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.validation.ValidationException;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AssignableCond;
import org.apache.syncope.core.persistence.api.dao.search.AttributeCond;
import org.apache.syncope.core.persistence.api.dao.search.DynRealmCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAPlainSchema;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractAnySearchDAO
extends AbstractDAO<Any<?>>
implements AnySearchDAO {
    private static final String[] ORDER_BY_NOT_ALLOWED = new String[]{"serialVersionUID", "password", "securityQuestion", "securityAnswer", "token", "tokenExpireTime"};
    @Autowired
    protected RealmDAO realmDAO;
    @Autowired
    protected DynRealmDAO dynRealmDAO;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected PlainSchemaDAO schemaDAO;
    @Autowired
    protected AnyUtilsFactory anyUtilsFactory;

    protected SearchCond buildEffectiveCond(SearchCond cond, Set<String> dynRealmKeys) {
        List effectiveConds = (List)CollectionUtils.collect(dynRealmKeys, (Transformer)new Transformer<String, SearchCond>(){

            public SearchCond transform(String input) {
                DynRealmCond dynRealmCond = new DynRealmCond();
                dynRealmCond.setDynRealm(input);
                return SearchCond.getLeafCond((DynRealmCond)dynRealmCond);
            }
        }, new ArrayList());
        effectiveConds.add(cond);
        return SearchCond.getAndCond((List)effectiveConds);
    }

    protected abstract int doCount(Set<String> var1, SearchCond var2, AnyTypeKind var3);

    public int count(Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        if (adminRealms == null || adminRealms.isEmpty()) {
            LOG.error("No realms provided");
            return 0;
        }
        LOG.debug("Search condition:\n{}", (Object)cond);
        if (cond == null || !cond.isValid()) {
            LOG.error("Invalid search condition:\n{}", (Object)cond);
            return 0;
        }
        return this.doCount(adminRealms, cond, kind);
    }

    public <T extends Any<?>> List<T> search(SearchCond cond, AnyTypeKind kind) {
        return this.search(cond, Collections.emptyList(), kind);
    }

    public <T extends Any<?>> List<T> search(SearchCond cond, List<OrderByClause> orderBy, AnyTypeKind kind) {
        return this.search(SyncopeConstants.FULL_ADMIN_REALMS, cond, -1, -1, orderBy, kind);
    }

    protected List<OrderByClause> filterOrderBy(List<OrderByClause> orderBy) {
        return ListUtils.select(orderBy, (Predicate)new Predicate<OrderByClause>(){

            public boolean evaluate(OrderByClause clause) {
                return !ArrayUtils.contains((Object[])ORDER_BY_NOT_ALLOWED, (Object)clause.getField());
            }
        });
    }

    protected abstract <T extends Any<?>> List<T> doSearch(Set<String> var1, SearchCond var2, int var3, int var4, List<OrderByClause> var5, AnyTypeKind var6);

    protected Pair<PlainSchema, PlainAttrValue> check(AttributeCond cond, AnyTypeKind kind) {
        AnyUtils attrUtils = this.anyUtilsFactory.getInstance(kind);
        PlainSchema schema = (PlainSchema)this.schemaDAO.find(cond.getSchema());
        if (schema == null) {
            LOG.warn("Ignoring invalid schema '{}'", (Object)cond.getSchema());
            throw new IllegalArgumentException();
        }
        PlainAttrValue attrValue = attrUtils.newPlainAttrValue();
        try {
            if (cond.getType() != AttributeCond.Type.LIKE && cond.getType() != AttributeCond.Type.ILIKE && cond.getType() != AttributeCond.Type.ISNULL && cond.getType() != AttributeCond.Type.ISNOTNULL) {
                schema.getValidator().validate(cond.getExpression(), attrValue);
            }
        }
        catch (ValidationException e) {
            LOG.error("Could not validate expression '" + cond.getExpression() + "'", (Throwable)e);
            throw new IllegalArgumentException();
        }
        return Pair.of((Object)schema, (Object)attrValue);
    }

    protected Triple<PlainSchema, PlainAttrValue, AnyCond> check(AnyCond cond, AnyTypeKind kind) {
        Field anyField;
        AnyCond condClone = (AnyCond)SerializationUtils.clone((Serializable)cond);
        AnyUtils attrUtils = this.anyUtilsFactory.getInstance(kind);
        if ("key".equals(condClone.getSchema())) {
            condClone.setSchema("id");
        }
        if ((anyField = ReflectionUtils.findField((Class)attrUtils.anyClass(), (String)condClone.getSchema())) == null) {
            LOG.warn("Ignoring invalid schema '{}'", (Object)condClone.getSchema());
            throw new IllegalArgumentException();
        }
        JPAPlainSchema schema = new JPAPlainSchema();
        schema.setKey(anyField.getName());
        for (AttrSchemaType attrSchemaType : AttrSchemaType.values()) {
            if (!anyField.getType().isAssignableFrom(attrSchemaType.getType())) continue;
            schema.setType(attrSchemaType);
        }
        boolean foundBooleanMin = false;
        boolean foundBooleanMax = false;
        if (Integer.class.equals(anyField.getType())) {
            for (Annotation annotation : anyField.getAnnotations()) {
                if (Min.class.equals(annotation.annotationType())) {
                    foundBooleanMin = ((Min)annotation).value() == 0L;
                    continue;
                }
                if (!Max.class.equals(annotation.annotationType())) continue;
                foundBooleanMax = ((Max)annotation).value() == 1L;
            }
        }
        if (foundBooleanMin && foundBooleanMax) {
            schema.setType(AttrSchemaType.Boolean);
        }
        if (anyField.getType().getAnnotation(Entity.class) != null) {
            Method relMethod = null;
            try {
                relMethod = ClassUtils.getPublicMethod(anyField.getType(), (String)"getKey", (Class[])new Class[0]);
            }
            catch (Exception e) {
                LOG.error("Could not find {}#getKey", anyField.getType(), (Object)e);
            }
            if (relMethod != null && String.class.isAssignableFrom(relMethod.getReturnType())) {
                condClone.setSchema(condClone.getSchema() + "_id");
                schema.setType(AttrSchemaType.String);
            }
        }
        PlainAttrValue attrValue = attrUtils.newPlainAttrValue();
        if (condClone.getType() != AttributeCond.Type.LIKE && condClone.getType() != AttributeCond.Type.ILIKE && condClone.getType() != AttributeCond.Type.ISNULL && condClone.getType() != AttributeCond.Type.ISNOTNULL) {
            try {
                schema.getValidator().validate(condClone.getExpression(), attrValue);
            }
            catch (ValidationException e) {
                LOG.error("Could not validate expression '" + condClone.getExpression() + "'", (Throwable)e);
                throw new IllegalArgumentException();
            }
        }
        return Triple.of((Object)schema, (Object)attrValue, (Object)condClone);
    }

    protected String check(MembershipCond cond) {
        String groupKey;
        if (SyncopeConstants.UUID_PATTERN.matcher(cond.getGroup()).matches()) {
            groupKey = cond.getGroup();
        } else {
            Group group = this.groupDAO.findByName(cond.getGroup());
            String string = groupKey = group == null ? null : group.getKey();
        }
        if (groupKey == null) {
            LOG.error("Could not find group for '" + cond.getGroup() + "'");
            throw new IllegalArgumentException();
        }
        return groupKey;
    }

    protected String check(RelationshipCond cond) {
        String rightAnyObjectKey;
        if (SyncopeConstants.UUID_PATTERN.matcher(cond.getAnyObject()).matches()) {
            rightAnyObjectKey = cond.getAnyObject();
        } else {
            AnyObject anyObject = this.anyObjectDAO.findByName(cond.getAnyObject());
            String string = rightAnyObjectKey = anyObject == null ? null : anyObject.getKey();
        }
        if (rightAnyObjectKey == null) {
            LOG.error("Could not find any object for '" + cond.getAnyObject() + "'");
            throw new IllegalArgumentException();
        }
        return rightAnyObjectKey;
    }

    protected Realm check(AssignableCond cond) {
        Realm realm = this.realmDAO.findByFullPath(cond.getRealmFullPath());
        if (realm == null) {
            LOG.error("Could not find realm for '" + cond.getRealmFullPath() + "'");
            throw new IllegalArgumentException();
        }
        return realm;
    }

    protected String check(MemberCond cond) {
        String memberKey;
        if (SyncopeConstants.UUID_PATTERN.matcher(cond.getMember()).matches()) {
            memberKey = cond.getMember();
        } else {
            User member = this.userDAO.findByUsername(cond.getMember());
            if (member == null) {
                member = this.anyObjectDAO.findByName(cond.getMember());
            }
            String string = memberKey = member == null ? null : member.getKey();
        }
        if (memberKey == null) {
            LOG.error("Could not find user or any object for '" + cond.getMember() + "'");
            throw new IllegalArgumentException();
        }
        return memberKey;
    }

    protected <T extends Any<?>> List<T> buildResult(List<Object> raw, AnyTypeKind kind) {
        ArrayList<Any> result = new ArrayList<Any>();
        for (Object anyKey : raw) {
            Any any;
            String actualKey;
            String string = actualKey = anyKey instanceof Object[] ? (String)((Object[])anyKey)[0] : (String)anyKey;
            Any any2 = kind == AnyTypeKind.USER ? this.userDAO.find(actualKey) : (any = kind == AnyTypeKind.GROUP ? this.groupDAO.find(actualKey) : this.anyObjectDAO.find(actualKey));
            if (any == null) {
                LOG.error("Could not find {} with id {}, even if returned by native query", (Object)kind, (Object)actualKey);
                continue;
            }
            if (result.contains(any)) continue;
            result.add(any);
        }
        return result;
    }

    public <T extends Any<?>> List<T> search(Set<String> adminRealms, SearchCond cond, int page, int itemsPerPage, List<OrderByClause> orderBy, AnyTypeKind kind) {
        List<OrderByClause> effectiveOrderBy;
        if (adminRealms == null || adminRealms.isEmpty()) {
            LOG.error("No realms provided");
            return Collections.emptyList();
        }
        LOG.debug("Search condition:\n{}", (Object)cond);
        if (cond == null || !cond.isValid()) {
            LOG.error("Invalid search condition:\n{}", (Object)cond);
            return Collections.emptyList();
        }
        if (orderBy.isEmpty()) {
            OrderByClause keyClause = new OrderByClause();
            keyClause.setField("key");
            keyClause.setDirection(OrderByClause.Direction.ASC);
            effectiveOrderBy = Collections.singletonList(keyClause);
        } else {
            effectiveOrderBy = orderBy;
        }
        return this.doSearch(adminRealms, cond, page, itemsPerPage, effectiveOrderBy, kind);
    }

    public <T extends Any<?>> boolean matches(T any, SearchCond cond) {
        AnyCond keycond = new AnyCond(AttributeCond.Type.EQ);
        keycond.setSchema("key");
        keycond.setExpression(any.getKey());
        return !this.search(SearchCond.getAndCond((SearchCond)SearchCond.getLeafCond((AttributeCond)keycond), (SearchCond)cond), any.getType().getKind()).isEmpty();
    }
}

