/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import org.apache.commons.jexl3.parser.Parser;
import org.apache.commons.jexl3.parser.Token;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.core.persistence.api.dao.AllowedSchemas;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttributeCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.anyobject.AMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.group.TypeExtension;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.AbstractPlainAttrValue;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractAnyDAO<A extends Any<?>>
extends AbstractDAO<A>
implements AnyDAO<A> {
    @Autowired
    protected ApplicationEventPublisher publisher;
    private PlainSchemaDAO plainSchemaDAO;
    private DerSchemaDAO derSchemaDAO;
    private DynRealmDAO dynRealmDAO;
    private AnyUtils anyUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlainSchemaDAO plainSchemaDAO() {
        AbstractAnyDAO abstractAnyDAO = this;
        synchronized (abstractAnyDAO) {
            if (this.plainSchemaDAO == null) {
                this.plainSchemaDAO = (PlainSchemaDAO)ApplicationContextProvider.getApplicationContext().getBean(PlainSchemaDAO.class);
            }
        }
        return this.plainSchemaDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DerSchemaDAO derSchemaDAO() {
        AbstractAnyDAO abstractAnyDAO = this;
        synchronized (abstractAnyDAO) {
            if (this.derSchemaDAO == null) {
                this.derSchemaDAO = (DerSchemaDAO)ApplicationContextProvider.getApplicationContext().getBean(DerSchemaDAO.class);
            }
        }
        return this.derSchemaDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DynRealmDAO dynRealmDAO() {
        AbstractAnyDAO abstractAnyDAO = this;
        synchronized (abstractAnyDAO) {
            if (this.dynRealmDAO == null) {
                this.dynRealmDAO = (DynRealmDAO)ApplicationContextProvider.getApplicationContext().getBean(DynRealmDAO.class);
            }
        }
        return this.dynRealmDAO;
    }

    protected abstract AnyUtils init();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AnyUtils anyUtils() {
        AbstractAnyDAO abstractAnyDAO = this;
        synchronized (abstractAnyDAO) {
            if (this.anyUtils == null) {
                this.anyUtils = this.init();
            }
        }
        return this.anyUtils;
    }

    protected String findKey(String name, String table) {
        Query query = this.entityManager().createNativeQuery("SELECT id FROM " + table + " WHERE " + ("SyncopeUser".equals(table) ? "username" : "name") + "=?");
        query.setParameter(1, (Object)name);
        String key = null;
        for (Object resultKey : query.getResultList()) {
            key = resultKey instanceof Object[] ? (String)((Object[])resultKey)[0] : (String)resultKey;
        }
        return key;
    }

    protected Date findLastChange(String key, String table) {
        Query query = this.entityManager().createNativeQuery("SELECT creationDate, lastChangeDate FROM " + table + " WHERE id=?");
        query.setParameter(1, (Object)key);
        List result = query.getResultList();
        Date creationDate = null;
        Date lastChangeDate = null;
        if (!result.isEmpty()) {
            creationDate = (Date)((Object[])result.get(0))[0];
            lastChangeDate = (Date)((Object[])result.get(0))[1];
        }
        return lastChangeDate == null ? creationDate : lastChangeDate;
    }

    protected abstract void securityChecks(A var1);

    @Transactional(readOnly=true)
    public A authFind(String key) {
        if (key == null) {
            throw new NotFoundException("Null key");
        }
        A any = this.find(key);
        if (any == null) {
            throw new NotFoundException(StringUtils.substringBefore((String)StringUtils.substringAfter((String)this.getClass().getSimpleName(), (String)"JPA"), (String)"DAO") + " " + key);
        }
        this.securityChecks(any);
        return any;
    }

    @Transactional(readOnly=true)
    public A find(String key) {
        return (A)((Any)this.entityManager().find(this.anyUtils().anyClass(), (Object)key));
    }

    public A findByWorkflowId(String workflowId) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + this.anyUtils().anyClass().getSimpleName() + " e WHERE e.workflowId = :workflowId", User.class);
        query.setParameter("workflowId", (Object)workflowId);
        Any result = null;
        try {
            result = (Any)query.getSingleResult();
        }
        catch (NoResultException e) {
            LOG.debug("No user found with workflow id {}", (Object)workflowId, (Object)e);
        }
        return (A)result;
    }

    private Query findByPlainAttrValueQuery(String entityName) {
        return this.entityManager().createQuery("SELECT e FROM " + entityName + " e WHERE e.attribute.schema.id = :schemaKey AND (e.stringValue IS NOT NULL AND e.stringValue = :stringValue) OR (e.booleanValue IS NOT NULL AND e.booleanValue = :booleanValue) OR (e.dateValue IS NOT NULL AND e.dateValue = :dateValue) OR (e.longValue IS NOT NULL AND e.longValue = :longValue) OR (e.doubleValue IS NOT NULL AND e.doubleValue = :doubleValue)");
    }

    public List<A> findByPlainAttrValue(String schemaKey, PlainAttrValue attrValue) {
        PlainSchema schema = (PlainSchema)this.plainSchemaDAO().find(schemaKey);
        if (schema == null) {
            LOG.error("Invalid schema name '{}'", (Object)schemaKey);
            return Collections.emptyList();
        }
        String entityName = schema.isUniqueConstraint() ? this.anyUtils().plainAttrUniqueValueClass().getName() : this.anyUtils().plainAttrValueClass().getName();
        Query query = this.findByPlainAttrValueQuery(entityName);
        query.setParameter("schemaKey", (Object)schemaKey);
        query.setParameter("stringValue", (Object)attrValue.getStringValue());
        query.setParameter("booleanValue", attrValue.getBooleanValue() == null ? null : ((AbstractPlainAttrValue)attrValue).getBooleanAsInteger(attrValue.getBooleanValue()));
        if (attrValue.getDateValue() == null) {
            query.setParameter("dateValue", null);
        } else {
            query.setParameter("dateValue", attrValue.getDateValue(), TemporalType.TIMESTAMP);
        }
        query.setParameter("longValue", (Object)attrValue.getLongValue());
        query.setParameter("doubleValue", (Object)attrValue.getDoubleValue());
        ArrayList<Any> result = new ArrayList<Any>();
        for (PlainAttrValue value : query.getResultList()) {
            Any any = value.getAttr().getOwner();
            if (result.contains(any)) continue;
            result.add(any);
        }
        return result;
    }

    public A findByPlainAttrUniqueValue(String schemaKey, PlainAttrValue attrUniqueValue) {
        PlainSchema schema = (PlainSchema)this.plainSchemaDAO().find(schemaKey);
        if (schema == null) {
            LOG.error("Invalid schema name '{}'", (Object)schemaKey);
            return null;
        }
        if (!schema.isUniqueConstraint()) {
            LOG.error("This schema has not unique constraint: '{}'", (Object)schemaKey);
            return null;
        }
        List<A> result = this.findByPlainAttrValue(schemaKey, attrUniqueValue);
        return (A)(result.isEmpty() ? null : (Any)result.iterator().next());
    }

    private List<String> split(String attrValue, List<String> literals) {
        ArrayList<String> attrValues = new ArrayList<String>();
        if (literals.isEmpty()) {
            attrValues.add(attrValue);
        } else {
            for (String token : attrValue.split(Pattern.quote(literals.get(0)))) {
                if (token.isEmpty()) continue;
                attrValues.addAll(this.split(token, literals.subList(1, literals.size())));
            }
        }
        return attrValues;
    }

    private Set<String> getWhereClause(String expression, String value) {
        Parser parser = new Parser((Reader)new StringReader(expression));
        ArrayList<String> identifiers = new ArrayList<String>();
        ArrayList<String> literals = new ArrayList<String>();
        Token token = parser.getNextToken();
        while (token != null && StringUtils.isNotBlank((CharSequence)token.toString())) {
            if (token.kind == 82) {
                literals.add(token.toString().substring(1, token.toString().length() - 1));
            }
            if (token.kind == 76) {
                identifiers.add(token.toString());
            }
            token = parser.getNextToken();
        }
        Collections.sort(literals, new Comparator<String>(){

            @Override
            public int compare(String t, String t1) {
                if (t == null && t1 == null) {
                    return 0;
                }
                if (t != null && t1 == null) {
                    return -1;
                }
                if (t == null && t1 != null) {
                    return 1;
                }
                if (t.length() == t1.length()) {
                    return 0;
                }
                if (t.length() > t1.length()) {
                    return -1;
                }
                return 1;
            }
        });
        List<String> attrValues = this.split(value, literals);
        if (attrValues.size() != identifiers.size()) {
            LOG.error("Ambiguous JEXL expression resolution: literals and values have different size");
            return Collections.emptySet();
        }
        HashSet<String> clauses = new HashSet<String>();
        StringBuilder bld = new StringBuilder();
        HashSet used = new HashSet();
        for (int i = 0; i < identifiers.size(); ++i) {
            if (used.contains(identifiers.get(i))) continue;
            PlainSchema schema = (PlainSchema)this.plainSchemaDAO().find((String)identifiers.get(i));
            if (schema == null) {
                LOG.error("Invalid schema '{}', ignoring", identifiers.get(i));
                continue;
            }
            bld.delete(0, bld.length());
            bld.append("(");
            bld.append("s.id = '").append((String)identifiers.get(i)).append("'");
            bld.append(" AND ");
            bld.append("s.id = a.schema_id").append(" AND ");
            bld.append("a.id = v.attribute_id");
            bld.append(" AND ");
            switch (schema.getType()) {
                case Boolean: {
                    bld.append("v.booleanValue = '").append(attrValues.get(i)).append("'");
                    break;
                }
                case Long: {
                    bld.append("v.longValue = ").append(attrValues.get(i));
                    break;
                }
                case Double: {
                    bld.append("v.doubleValue = ").append(attrValues.get(i));
                    break;
                }
                case Date: {
                    bld.append("v.dateValue = '").append(attrValues.get(i)).append("'");
                    break;
                }
                default: {
                    bld.append("v.stringValue = '").append(attrValues.get(i)).append("'");
                }
            }
            bld.append(")");
            used.add(identifiers.get(i));
            clauses.add(bld.toString());
        }
        LOG.debug("Generated where clauses {}", clauses);
        return clauses;
    }

    public List<A> findByDerAttrValue(String schemaKey, String value) {
        DerSchema schema = (DerSchema)this.derSchemaDAO().find(schemaKey);
        if (schema == null) {
            LOG.error("Invalid schema name '{}'", (Object)schemaKey);
            return Collections.emptyList();
        }
        StringBuilder querystring = new StringBuilder();
        boolean subquery = false;
        for (String clause : this.getWhereClause(schema.getExpression(), value)) {
            if (querystring.length() > 0) {
                subquery = true;
                querystring.append(" AND a.owner_id IN ( ");
            }
            querystring.append("SELECT a.owner_id ").append("FROM ").append(this.anyUtils().plainAttrClass().getSimpleName().substring(3)).append(" a, ").append(this.anyUtils().plainAttrValueClass().getSimpleName().substring(3)).append(" v, ").append(PlainSchema.class.getSimpleName()).append(" s ").append("WHERE ").append(clause);
            if (!subquery) continue;
            querystring.append(')');
        }
        ArrayList<A> result = new ArrayList<A>();
        if (querystring.length() > 0) {
            Query query = this.entityManager().createNativeQuery(querystring.toString());
            for (Object anyKey : query.getResultList()) {
                A any = this.find(anyKey.toString());
                if (result.contains(any)) continue;
                result.add(any);
            }
        }
        return result;
    }

    public List<A> findByResource(ExternalResource resource) {
        Query query = this.entityManager().createQuery("SELECT e FROM " + this.anyUtils().anyClass().getSimpleName() + " e WHERE :resource MEMBER OF e.resources");
        query.setParameter("resource", (Object)resource);
        return query.getResultList();
    }

    public SearchCond getAllMatchingCond() {
        AnyCond idCond = new AnyCond(AttributeCond.Type.ISNOTNULL);
        idCond.setSchema("id");
        return SearchCond.getLeafCond((AttributeCond)idCond);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public <S extends Schema> AllowedSchemas<S> findAllowedSchemas(A any, Class<S> reference) {
        AllowedSchemas result = new AllowedSchemas();
        HashSet typeOwnClasses = new HashSet();
        typeOwnClasses.addAll(any.getType().getClasses());
        typeOwnClasses.addAll(any.getAuxClasses());
        for (AnyTypeClass typeClass : typeOwnClasses) {
            if (reference.equals(PlainSchema.class)) {
                result.getForSelf().addAll(typeClass.getPlainSchemas());
                continue;
            }
            if (reference.equals(DerSchema.class)) {
                result.getForSelf().addAll(typeClass.getDerSchemas());
                continue;
            }
            if (!reference.equals(VirSchema.class)) continue;
            result.getForSelf().addAll(typeClass.getVirSchemas());
        }
        HashMap<Any, List> typeExtensionClasses = new HashMap<Any, List>();
        if (any instanceof User) {
            for (UMembership uMembership : ((User)any).getMemberships()) {
                for (TypeExtension typeExtension : ((Group)uMembership.getRightEnd()).getTypeExtensions()) {
                    typeExtensionClasses.put(uMembership.getRightEnd(), typeExtension.getAuxClasses());
                }
            }
        } else if (any instanceof AnyObject) {
            for (AMembership aMembership : ((AnyObject)any).getMemberships()) {
                for (TypeExtension typeExtension : ((Group)aMembership.getRightEnd()).getTypeExtensions()) {
                    if (!any.getType().equals(typeExtension.getAnyType())) continue;
                    typeExtensionClasses.put(aMembership.getRightEnd(), typeExtension.getAuxClasses());
                }
            }
        }
        for (Map.Entry entry : typeExtensionClasses.entrySet()) {
            result.getForMemberships().put(entry.getKey(), new HashSet());
            for (AnyTypeClass typeClass : (List)entry.getValue()) {
                if (reference.equals(PlainSchema.class)) {
                    ((Set)result.getForMemberships().get(entry.getKey())).addAll(typeClass.getPlainSchemas());
                    continue;
                }
                if (reference.equals(DerSchema.class)) {
                    ((Set)result.getForMemberships().get(entry.getKey())).addAll(typeClass.getDerSchemas());
                    continue;
                }
                if (!reference.equals(VirSchema.class)) continue;
                ((Set)result.getForMemberships().get(entry.getKey())).addAll(typeClass.getVirSchemas());
            }
        }
        return result;
    }

    public A save(A any) {
        return (A)((Any)this.entityManager().merge(any));
    }

    public void delete(String key) {
        A any = this.find(key);
        if (any == null) {
            return;
        }
        this.delete((Any)any);
    }

    @Transactional(readOnly=true)
    public List<String> findDynRealms(String key) {
        Query query = this.entityManager().createNativeQuery("SELECT dynRealm_id FROM DynRealmMembers WHERE any_id=?");
        query.setParameter(1, (Object)key);
        ArrayList<String> result = new ArrayList<String>();
        for (Object resultKey : query.getResultList()) {
            String actualKey = resultKey instanceof Object[] ? (String)((Object[])resultKey)[0] : (String)resultKey;
            DynRealm dynRealm = this.dynRealmDAO().find(actualKey);
            if (dynRealm == null) {
                LOG.error("Could not find dynRealm with id {}, even though returned by the native query", (Object)actualKey);
                continue;
            }
            if (result.contains(actualKey)) continue;
            result.add(actualKey);
        }
        return result;
    }
}

