/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.wicket.util.lang.Generics;

public class ListUtils {
    private static final int MAX = 20;

    private ListUtils() {
    }

    public static int random(int bound) {
        return new Random((long)(Math.random() * 1000000.0)).nextInt(bound);
    }

    public static <T> T random(T[] array) {
        if (array.length > 0) {
            return array[ListUtils.random(array.length)];
        }
        return null;
    }

    public static <T> T random(List<T> list) {
        if (!list.isEmpty()) {
            return list.get(ListUtils.random(list.size()));
        }
        return null;
    }

    public static double random(int min, int max) {
        return (double)min + Math.random() * (double)(max - min);
    }

    public static void empty(List<?> list) {
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public static synchronized <T> T fromHash(int hash, List<T> list) {
        int index = ListUtils.indexOf(hash, list);
        if (index > -1) {
            return list.get(index);
        }
        return null;
    }

    public static synchronized int indexOf(int hash, List<?> list) {
        Iterator<?> iterator = list.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (iterator.next().hashCode() == hash) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static synchronized <T> void move(T item, int index, List<T> list) {
        if (index < list.size()) {
            list.add(index, list.remove(ListUtils.indexOf(item.hashCode(), list)));
        }
    }

    public static <T> List<T> contains(String search, List<T> list) {
        return ListUtils.contains(search, list, 20);
    }

    public static <T> List<T> contains(String search, List<T> list, int max) {
        ArrayList choices = Generics.newArrayList();
        String searchLowerCase = search.toLowerCase();
        int count = 0;
        for (T choice : list) {
            if (!choice.toString().toLowerCase().contains(searchLowerCase)) continue;
            choices.add(choice);
            if (++count != max) continue;
            break;
        }
        return choices;
    }

    public static <T> List<T> startsWith(String search, List<T> list) {
        return ListUtils.startsWith(search, list, 20);
    }

    public static <T> List<T> startsWith(String search, List<T> list, int max) {
        ArrayList choices = Generics.newArrayList();
        String searchLowerCase = search.toLowerCase();
        int count = 0;
        for (T choice : list) {
            if (!choice.toString().toLowerCase().startsWith(searchLowerCase)) continue;
            choices.add(choice);
            if (++count != max) continue;
            break;
        }
        return choices;
    }

    public static List<String> exclude(List<String> list, String ... items) {
        return ListUtils.exclude(list, Arrays.asList(items));
    }

    public static List<String> exclude(List<String> list, List<String> items) {
        ArrayList<String> copy = new ArrayList<String>(list);
        for (String item : items) {
            copy.remove(item);
        }
        return copy;
    }
}

