/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;

public class DateUtils {
    public static final String ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String ISO8601_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String ISO8601_UTC = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DATE_PATTERN = "MM/dd/yyyy";
    public static final String TIME_PATTERN = "h:mm aa";
    public static final String LOCAL_DATE_PATTERN = "MM/dd/yyyy";
    public static final String LOCAL_TIME_PATTERN = "h:mm a";
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    private DateUtils() {
    }

    public static long utc() {
        return DateUtils.utc(new Date());
    }

    public static long utc(Date date) {
        return DateUtils.utc(date.getTime());
    }

    public static long utc(long date) {
        return date - DateUtils.offset(date);
    }

    public static long utc(String date) throws ParseException {
        return DateUtils.utc(DateUtils.parse(date).getTime());
    }

    public static long offset(long time) {
        return TimeZone.getDefault().getOffset(time);
    }

    public static Date parse(String date) throws ParseException {
        return new SimpleDateFormat(ISO8601).parse(date);
    }

    public static String toString(Date date) {
        return new SimpleDateFormat(ISO8601_TZ).format(date);
    }

    public static String toUTCString(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(ISO8601_UTC);
        formatter.setTimeZone(UTC);
        return formatter.format(date);
    }

    public static long addHours(long date, int hours) {
        Calendar calendar = Calendar.getInstance(UTC);
        calendar.setTimeInMillis(date);
        calendar.add(10, hours);
        return calendar.getTimeInMillis();
    }

    public static Date addHours(Date date, int hours) {
        Calendar calendar = Calendar.getInstance(UTC);
        calendar.setTime(date);
        calendar.add(10, hours);
        return calendar.getTime();
    }

    public static Date dateOf(Date date, Date time) {
        return DateUtils.toDate(DateUtils.toLocalDate(date), DateUtils.toLocalTime(time));
    }

    public static Date toDate(LocalDate date, LocalTime time) {
        return DateUtils.toDate(DateUtils.toLocalDateTime(date, time));
    }

    public static Date toDate(LocalDateTime datetime) {
        return DateUtils.toDate(datetime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(Instant instant) {
        return new Date(instant.toEpochMilli());
    }

    public static LocalDate toLocalDate(Date date) {
        if (date != null) {
            return DateUtils.toLocalDate(date.getTime());
        }
        return null;
    }

    public static LocalDate toLocalDate(long timestamp) {
        return DateUtils.toLocalDate(Instant.ofEpochMilli((long)timestamp));
    }

    public static LocalDate toLocalDate(Instant instant) {
        return ZonedDateTime.ofInstant((Instant)instant, (ZoneId)ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalTime toLocalTime(Date time) {
        if (time != null) {
            return DateUtils.toLocalTime(time.getTime());
        }
        return null;
    }

    public static LocalTime toLocalTime(long timestamp) {
        return DateUtils.toLocalTime(Instant.ofEpochMilli((long)timestamp));
    }

    public static LocalTime toLocalTime(Instant instant) {
        return ZonedDateTime.ofInstant((Instant)instant, (ZoneId)ZoneId.systemDefault()).toLocalTime();
    }

    public static LocalDateTime toLocalDateTime(LocalDate date, LocalTime time) {
        return LocalDateTime.of((LocalDate)date, (LocalTime)(time != null ? time : LocalTime.MIDNIGHT));
    }
}

