/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.component;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.cocoon.pipeline.SetupException;
import org.apache.cocoon.pipeline.util.StringRepresentation;
import org.apache.cocoon.sax.AbstractSAXTransformer;
import org.apache.cocoon.sax.SAXConsumer;
import org.apache.cocoon.sax.component.TraxErrorListener;
import org.apache.cocoon.sax.util.InMemoryLRUResourceCache;
import org.apache.cocoon.sax.util.SAXConsumerAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTTransformer
extends AbstractSAXTransformer {
    private static final InMemoryLRUResourceCache<Templates> XSLT_CACHE = new InMemoryLRUResourceCache();
    private static final SAXTransformerFactory TRAX_FACTORY = XSLTTransformer.createNewSAXTransformerFactory();
    private static final Pattern XSLT_PARAMETER_NAME_PATTERN = Pattern.compile("[a-zA-Z_][\\w\\-\\.]*");
    private final Log log = LogFactory.getLog(XSLTTransformer.class);
    private Map<String, Object> parameters;
    private URL source;
    private Templates templates;

    public XSLTTransformer() {
    }

    public XSLTTransformer(URL source) {
        this(source, null);
    }

    public XSLTTransformer(URL source, Map<String, Object> attributes) {
        this.loadXSLT(source, attributes);
    }

    private void loadXSLT(URL source, Map<String, Object> attributes) {
        if (source == null) {
            throw new IllegalArgumentException("The parameter 'source' mustn't be null.");
        }
        this.source = source;
        if (XSLT_CACHE.containsKey(source)) {
            this.templates = XSLT_CACHE.get(this.source);
        } else {
            SAXTransformerFactory transformerFactory;
            StreamSource urlSource = new StreamSource(this.source.toExternalForm());
            if (attributes != null && !attributes.isEmpty()) {
                transformerFactory = XSLTTransformer.createNewSAXTransformerFactory();
                for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
                    String name = attribute.getKey();
                    Object value = attribute.getValue();
                    transformerFactory.setAttribute(name, value);
                }
            } else {
                transformerFactory = TRAX_FACTORY;
            }
            try {
                this.templates = transformerFactory.newTemplates(urlSource);
                XSLT_CACHE.put(this.source, this.templates);
            }
            catch (TransformerConfigurationException e) {
                throw new SetupException("Impossible to read XSLT from '" + this.source.toExternalForm() + "', see nested exception", (Throwable)e);
            }
        }
    }

    public void setParameters(Map<String, ? extends Object> parameters) {
        this.parameters = parameters != null ? new HashMap<String, Object>(parameters) : null;
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        try {
            this.source = (URL)configuration.get("source");
        }
        catch (ClassCastException cce) {
            throw new SetupException("The configuration value of 'source' can't be cast to java.net.URL.", (Throwable)cce);
        }
        if (this.source != null) {
            Object attributesObj = configuration.get("attributes");
            if (attributesObj != null && attributesObj instanceof Map) {
                this.loadXSLT(this.source, (Map)attributesObj);
            } else {
                this.loadXSLT(this.source, null);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Impossible to load XSLT parameters from '" + this.source + "' source, make sure it is NOT null and is a valid URL"));
        }
        this.setParameters(configuration);
    }

    @Override
    protected void setSAXConsumer(SAXConsumer consumer) {
        TransformerHandler transformerHandler;
        try {
            transformerHandler = TRAX_FACTORY.newTransformerHandler(this.templates);
        }
        catch (Exception ex) {
            throw new SetupException("Could not initialize transformer handler.", (Throwable)ex);
        }
        if (this.parameters != null) {
            Transformer transformer = transformerHandler.getTransformer();
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                String name = entry.getKey();
                if (!XSLT_PARAMETER_NAME_PATTERN.matcher(name).matches()) continue;
                transformer.setParameter(name, entry.getValue());
            }
        }
        SAXResult result = new SAXResult();
        result.setHandler(consumer);
        result.setLexicalHandler(consumer);
        transformerHandler.setResult(result);
        TraxErrorListener traxErrorListener = new TraxErrorListener(this.log, this.source.toExternalForm());
        transformerHandler.getTransformer().setErrorListener(traxErrorListener);
        SAXConsumerAdapter saxConsumerAdapter = new SAXConsumerAdapter();
        saxConsumerAdapter.setContentHandler(transformerHandler);
        super.setSAXConsumer(saxConsumerAdapter);
    }

    private static SAXTransformerFactory createNewSAXTransformerFactory() {
        return (SAXTransformerFactory)TransformerFactory.newInstance();
    }

    @Override
    public String toString() {
        return StringRepresentation.buildString((Object)this, (String[])new String[]{"src=" + this.source});
    }
}

