/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.component;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.cocoon.sax.component.AbstractLinkRewriterTransformer;
import org.apache.cocoon.sax.component.LinkRewriterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexpLinkRewriterTransformer
extends AbstractLinkRewriterTransformer {
    private static final String REGEXP_PREFIX = "regexp";
    private final transient Map<Pattern, String> matchingMap = new HashMap<Pattern, String>();

    public RegexpLinkRewriterTransformer() {
    }

    public RegexpLinkRewriterTransformer(Map<String, String> regexpMatch) {
        this.init(regexpMatch);
    }

    @Override
    public void setup(Map<String, Object> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        super.setup(parameters);
        HashMap<String, String> regexpMatch = new HashMap<String, String>();
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            if (!parameter.getKey().startsWith(REGEXP_PREFIX)) continue;
            String[] split = ((String)parameter.getValue()).split(" ");
            if (split.length == 2) {
                regexpMatch.put(split[0], split[1]);
                continue;
            }
            LOG.error((Object)("Invalid regexp as parameter, ignoring: " + parameter.getValue()));
        }
        this.init(regexpMatch);
    }

    private void init(Map<String, String> regexpMatch) {
        if (regexpMatch != null && !regexpMatch.isEmpty()) {
            for (Map.Entry<String, String> entry : regexpMatch.entrySet()) {
                try {
                    this.matchingMap.put(Pattern.compile(entry.getKey()), entry.getValue());
                }
                catch (PatternSyntaxException e) {
                    LOG.error((Object)("Could not compile regular expression '" + entry.getKey() + "'"), (Throwable)e);
                }
            }
        }
    }

    @Override
    protected String rewrite(String elementNS, String elementName, String attributeNS, String attributeName, String link) throws LinkRewriterException {
        String result = link;
        Iterator<Map.Entry<Pattern, String>> itor = this.matchingMap.entrySet().iterator();
        while (itor.hasNext() && result.equals(link)) {
            Map.Entry<Pattern, String> entry = itor.next();
            Matcher matcher = entry.getKey().matcher(link);
            result = matcher.replaceAll(entry.getValue());
        }
        if (LOG.isDebugEnabled() && link.equals(result)) {
            LOG.debug((Object)("No match found for '" + link + "'"));
        }
        return result;
    }
}

