/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.migration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.java.job.SetUMembershipsJob;
import org.apache.syncope.core.provisioning.java.pushpull.SchedulingPullActions;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class MigrationPullActions
extends SchedulingPullActions {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationPullActions.class);
    private static final String CIPHER_ALGORITHM_ATTR = "cipherAlgorithm";
    private static final String RESOURCES_ATTR = "__RESOURCES__";
    private static final String MEMBERSHIPS_ATTR = "__MEMBERSHIPS__";
    @Autowired
    private UserDAO userDAO;
    private final Map<String, Set<String>> memberships = new HashMap<String, Set<String>>();

    public void beforeProvision(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entity) throws JobExecutionException {
        Attribute resourcesAttr = delta.getObject().getAttributeByName(RESOURCES_ATTR);
        if (entity instanceof AnyTO && resourcesAttr != null && resourcesAttr.getValue() != null && !resourcesAttr.getValue().isEmpty()) {
            ((AnyTO)entity).getResources().addAll(CollectionUtils.collect((Iterable)resourcesAttr.getValue(), (Transformer)TransformerUtils.stringValueTransformer()));
        }
    }

    @Transactional
    public void after(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entity, ProvisioningReport result) throws JobExecutionException {
        if (entity instanceof UserTO) {
            CipherAlgorithm cipherAlgorithm = null;
            Attribute cipherAlgorithmAttr = delta.getObject().getAttributeByName(CIPHER_ALGORITHM_ATTR);
            if (cipherAlgorithmAttr != null && cipherAlgorithmAttr.getValue() != null && !cipherAlgorithmAttr.getValue().isEmpty()) {
                cipherAlgorithm = CipherAlgorithm.valueOf((String)cipherAlgorithmAttr.getValue().get(0).toString());
            }
            GuardedString passwordValue = AttributeUtil.getPasswordValue((Set)delta.getObject().getAttributes());
            if (cipherAlgorithm != null && passwordValue != null) {
                User user = (User)this.userDAO.find(entity.getKey());
                LOG.debug("Setting encoded password for {}", (Object)user);
                user.setEncodedPassword(SecurityUtil.decrypt((GuardedString)passwordValue), cipherAlgorithm);
            }
        } else if (entity instanceof GroupTO) {
            Attribute membershipsAttr = delta.getObject().getAttributeByName(MEMBERSHIPS_ATTR);
            if (membershipsAttr != null && membershipsAttr.getValue() != null && !membershipsAttr.getValue().isEmpty()) {
                LOG.debug("Found {} for group {}", (Object)MEMBERSHIPS_ATTR, (Object)entity.getKey());
                for (Object membership : membershipsAttr.getValue()) {
                    User member = this.userDAO.findByUsername(membership.toString());
                    if (member == null) {
                        LOG.warn("Could not find member {} for group {}", membership, (Object)entity.getKey());
                        continue;
                    }
                    Set<String> memb = this.memberships.get(member.getKey());
                    if (memb == null) {
                        memb = new HashSet<String>();
                        this.memberships.put(member.getKey(), memb);
                    }
                    memb.add(entity.getKey());
                }
            }
        } else {
            super.after(profile, delta, entity, result);
        }
    }

    public void afterAll(ProvisioningProfile<?, ?> profile) throws JobExecutionException {
        HashMap<String, Map<String, Set<String>>> jobMap = new HashMap<String, Map<String, Set<String>>>();
        jobMap.put("memberships", this.memberships);
        this.schedule(SetUMembershipsJob.class, jobMap);
    }
}

