/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import com.pingunaut.wicket.chartjs.chart.impl.Bar;
import com.pingunaut.wicket.chartjs.core.panel.BarChartPanel;
import com.pingunaut.wicket.chartjs.data.sets.BarDataSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.client.console.annotations.ExtWidget;
import org.apache.syncope.client.console.rest.CamelRoutesRestClient;
import org.apache.syncope.client.console.wicket.ajax.IndicatorAjaxTimerBehavior;
import org.apache.syncope.client.console.widgets.BaseExtWidget;
import org.apache.syncope.common.lib.to.CamelMetrics;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.time.Duration;

@ExtWidget(cssClass="col-md-6")
public class CamelMetricsWidget
extends BaseExtWidget {
    private static final long serialVersionUID = 4157815058487313617L;
    private List<CamelMetrics.MeanRate> meanRates;
    private final BarChartPanel chart;
    private final CamelRoutesRestClient restClient = new CamelRoutesRestClient();

    public CamelMetricsWidget(String id, PageReference pageRef) {
        super(id, pageRef);
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        CamelMetrics metrics = this.restClient.metrics();
        this.meanRates = new ArrayList<CamelMetrics.MeanRate>(5);
        for (int i = 0; i < 5; ++i) {
            this.meanRates.add((CamelMetrics.MeanRate)metrics.getResponseMeanRates().get(i));
        }
        this.chart = new BarChartPanel("chart", (IModel)Model.of((Serializable)this.build(this.meanRates)));
        container.add(new Component[]{this.chart});
        container.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.seconds((int)60)){
            private static final long serialVersionUID = -4426283634345968585L;

            protected void onTimer(AjaxRequestTarget target) {
                CamelMetrics metrics = CamelMetricsWidget.this.restClient.metrics();
                ArrayList updatedMeanRates = new ArrayList(5);
                for (int i = 0; i < 5; ++i) {
                    updatedMeanRates.add(metrics.getResponseMeanRates().get(i));
                }
                if (CamelMetricsWidget.this.refresh(updatedMeanRates)) {
                    target.add(new Component[]{CamelMetricsWidget.this});
                }
            }
        }});
    }

    private Bar build(List<CamelMetrics.MeanRate> meanRates) {
        Bar bar = new Bar();
        bar.getOptions().setScaleBeginAtZero(Boolean.valueOf(true));
        bar.getOptions().setScaleShowGridLines(Boolean.valueOf(true));
        bar.getOptions().setScaleGridLineWidth(Integer.valueOf(1));
        bar.getOptions().setBarShowStroke(Boolean.valueOf(true));
        bar.getOptions().setBarStrokeWidth(Integer.valueOf(2));
        bar.getOptions().setBarValueSpacing(Integer.valueOf(5));
        bar.getOptions().setBarDatasetSpacing(Integer.valueOf(1));
        bar.getOptions().setResponsive(true);
        bar.getOptions().setMaintainAspectRatio(Boolean.valueOf(true));
        bar.getData().setLabels((List)CollectionUtils.collect(meanRates, (Transformer)new Transformer<CamelMetrics.MeanRate, String>(){

            public String transform(CamelMetrics.MeanRate input) {
                return input.getRouteId();
            }
        }, new ArrayList()));
        BarDataSet dataset = new BarDataSet((List)CollectionUtils.collect(meanRates, (Transformer)new Transformer<CamelMetrics.MeanRate, Double>(){

            public Double transform(CamelMetrics.MeanRate input) {
                return input.getValue();
            }
        }, new ArrayList()));
        dataset.setFillColor("blue");
        bar.getData().setDatasets(Collections.singletonList(dataset));
        return bar;
    }

    private boolean refresh(List<CamelMetrics.MeanRate> meanRates) {
        if (!this.meanRates.equals(meanRates)) {
            this.meanRates = meanRates;
            this.chart.setDefaultModelObject((Object)this.build(meanRates));
            return true;
        }
        return false;
    }
}

