/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.rest.CamelRoutesRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.XMLEditorPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.to.CamelRouteTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;

public class CamelRoutesDirectoryPanel
extends DirectoryPanel<CamelRouteTO, CamelRouteTO, CamelRoutesProvider, CamelRoutesRestClient> {
    private static final long serialVersionUID = 3727444742501082182L;
    private static final String PREF_CAMEL_ROUTES_PAGINATOR_ROWS = "camel.routes.paginator.rows";
    private final BaseModal<String> utilityModal = new BaseModal("outer");
    private final AnyTypeKind anyTypeKind;

    public CamelRoutesDirectoryPanel(String id, PageReference pageRef, AnyTypeKind anyTypeKind) {
        super(id, new DirectoryPanel.Builder<CamelRouteTO, CamelRouteTO, CamelRoutesRestClient>(new CamelRoutesRestClient(), pageRef){
            private static final long serialVersionUID = 8769126634538601689L;

            protected WizardMgtPanel<CamelRouteTO> newInstance(String id, boolean wizardInModal) {
                throw new UnsupportedOperationException();
            }
        }.disableCheckBoxes());
        this.setOutputMarkupId(true);
        this.anyTypeKind = anyTypeKind;
        this.setFooterVisibility(true);
        this.addOuterObject(new Component[]{this.utilityModal});
        this.setWindowClosedReloadCallback(this.utilityModal);
        this.utilityModal.size(Modal.Size.Large);
        this.utilityModal.addSubmitButton();
        this.initResultTable();
    }

    protected CamelRoutesProvider dataProvider() {
        return new CamelRoutesProvider(this.anyTypeKind, this.rows);
    }

    protected String paginatorRowsKey() {
        return PREF_CAMEL_ROUTES_PAGINATOR_ROWS;
    }

    protected Collection<ActionLink.ActionType> getBulkActions() {
        return Collections.emptyList();
    }

    protected List<IColumn<CamelRouteTO, String>> getColumns() {
        ArrayList<IColumn<CamelRouteTO, String>> columns = new ArrayList<IColumn<CamelRouteTO, String>>();
        columns.add((IColumn<CamelRouteTO, String>)new PropertyColumn((IModel)new ResourceModel("key"), (Object)"key", "key"));
        return columns;
    }

    public ActionsPanel<CamelRouteTO> getActions(final IModel<CamelRouteTO> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<CamelRouteTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, CamelRouteTO ignore) {
                final CamelRouteTO route = ((CamelRoutesRestClient)CamelRoutesDirectoryPanel.this.restClient).read(CamelRoutesDirectoryPanel.this.anyTypeKind, ((CamelRouteTO)model.getObject()).getKey());
                CamelRoutesDirectoryPanel.this.utilityModal.header((IModel)Model.of((Serializable)((Object)route.getKey())));
                CamelRoutesDirectoryPanel.this.utilityModal.setContent((ModalPanel)new XMLEditorPanel(CamelRoutesDirectoryPanel.this.utilityModal, (IModel)new PropertyModel((Object)route, "content"), CamelRoutesDirectoryPanel.this.filtered, CamelRoutesDirectoryPanel.this.pageRef){
                    private static final long serialVersionUID = 5488080606102212554L;

                    public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                        try {
                            ((CamelRoutesRestClient)CamelRoutesDirectoryPanel.this.restClient).update(CamelRoutesDirectoryPanel.this.anyTypeKind, route);
                            this.info((Serializable)((Object)this.getString("operation_succeeded")));
                            this.modal.close((IPartialPageRequestHandler)target);
                        }
                        catch (Exception e) {
                            LOG.error("While creating or updating CamelRouteTO", (Throwable)e);
                            this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                        }
                        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                });
                CamelRoutesDirectoryPanel.this.utilityModal.show(true);
                target.add(new Component[]{CamelRoutesDirectoryPanel.this.utilityModal});
            }
        }, ActionLink.ActionType.EDIT, "ROUTE_UPDATE");
        return panel;
    }

    protected final class CamelRoutesProvider
    extends DirectoryDataProvider<CamelRouteTO> {
        private static final long serialVersionUID = -185944053385660794L;
        private final AnyTypeKind anyTypeKind;
        private final SortableDataProviderComparator<CamelRouteTO> comparator;

        private CamelRoutesProvider(AnyTypeKind anyTypeKind, int paginatorRows) {
            super(paginatorRows);
            this.anyTypeKind = anyTypeKind;
            this.comparator = new SortableDataProviderComparator((SortableDataProvider)this);
        }

        public Iterator<CamelRouteTO> iterator(long first, long count) {
            List<CamelRouteTO> list = ((CamelRoutesRestClient)CamelRoutesDirectoryPanel.this.restClient).list(this.anyTypeKind);
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((CamelRoutesRestClient)CamelRoutesDirectoryPanel.this.restClient).list(this.anyTypeKind).size();
        }

        public IModel<CamelRouteTO> model(CamelRouteTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

