/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Map;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;

public final class Uid
extends Attribute {
    public static final String NAME = AttributeUtil.createSpecialName("UID");
    private final String revision;
    private final Name nameHint;

    public Uid(String value) {
        super(NAME, CollectionUtil.newReadOnlyList(Uid.check(value)));
        this.revision = null;
        this.nameHint = null;
    }

    public Uid(String value, String revision) {
        super(NAME, CollectionUtil.newReadOnlyList(Uid.check(value)));
        if (StringUtil.isBlank(revision)) {
            throw new IllegalArgumentException("Revision value must not be blank!");
        }
        this.revision = revision;
        this.nameHint = null;
    }

    public Uid(String value, Name nameHint) {
        super(NAME, CollectionUtil.newReadOnlyList(Uid.check(value)));
        this.revision = null;
        this.nameHint = nameHint;
    }

    public Uid(String value, String revision, Name nameHint) {
        super(NAME, CollectionUtil.newReadOnlyList(Uid.check(value)));
        if (StringUtil.isBlank(revision)) {
            throw new IllegalArgumentException("Revision value must not be blank!");
        }
        this.revision = revision;
        this.nameHint = nameHint;
    }

    private static String check(String value) {
        if (StringUtil.isBlank(value)) {
            throw new IllegalArgumentException("Uid value must not be blank!");
        }
        return value;
    }

    public String getUidValue() {
        return AttributeUtil.getStringValue(this);
    }

    public Name getNameHint() {
        return this.nameHint;
    }

    public String getNameHintValue() {
        return AttributeUtil.getStringValue(this.nameHint);
    }

    public String getRevision() {
        return this.revision;
    }

    @Override
    protected void extendToStringMap(Map<String, Object> map) {
        super.extendToStringMap(map);
        if (this.revision != null) {
            map.put("Revision", this.revision);
        }
        if (this.nameHint != null) {
            map.put("NameHint", this.nameHint);
        }
    }
}

