/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.rs.security.common.RSSecurityUtils;
import org.apache.cxf.rs.security.saml.sso.SamlSSOAssertionValidator;
import org.apache.cxf.rs.security.xml.EncryptionUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.SignatureTrustValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.provider.ApacheSantuarioSignatureValidationProviderImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SAMLProtocolResponseValidator {
    public static final String SAML2_STATUSCODE_SUCCESS = "urn:oasis:names:tc:SAML:2.0:status:Success";
    public static final String SAML1_STATUSCODE_SUCCESS = "Success";
    private static final Logger LOG = LogUtils.getL7dLogger(SAMLProtocolResponseValidator.class);
    private Validator signatureValidator = new SignatureTrustValidator();
    private boolean keyInfoMustBeAvailable = true;
    private int futureTTL = 60;

    public void validateSamlResponse(Response samlResponse, Crypto sigCrypto, CallbackHandler callbackHandler) throws WSSecurityException {
        if (samlResponse.getStatus() == null || samlResponse.getStatus().getStatusCode() == null) {
            LOG.fine("Either the SAML Response Status or StatusCode is null");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        if (!SAML2_STATUSCODE_SUCCESS.equals(samlResponse.getStatus().getStatusCode().getValue())) {
            LOG.fine("SAML Status code of " + samlResponse.getStatus().getStatusCode().getValue() + "does not equal " + SAML2_STATUSCODE_SUCCESS);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        if (samlResponse.getIssueInstant() != null) {
            DateTime currentTime = new DateTime();
            currentTime = currentTime.plusSeconds(this.futureTTL);
            if (samlResponse.getIssueInstant().isAfter((ReadableInstant)currentTime)) {
                LOG.fine("SAML Response IssueInstant not met");
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
            }
        }
        if (SAMLVersion.VERSION_20 != samlResponse.getVersion()) {
            LOG.fine("SAML Version of " + samlResponse.getVersion() + "does not equal " + SAMLVersion.VERSION_20);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        this.validateResponseSignature(samlResponse, sigCrypto, callbackHandler);
        Document doc = samlResponse.getDOM().getOwnerDocument();
        for (EncryptedAssertion assertion : samlResponse.getEncryptedAssertions()) {
            Element decAssertion = this.decryptAssertion(assertion, sigCrypto, callbackHandler);
            SamlAssertionWrapper wrapper = new SamlAssertionWrapper(decAssertion);
            samlResponse.getAssertions().add(wrapper.getSaml2());
        }
        for (EncryptedAssertion assertion : samlResponse.getAssertions()) {
            SamlAssertionWrapper wrapper = new SamlAssertionWrapper((SAMLObject)assertion);
            this.validateAssertion(wrapper, sigCrypto, callbackHandler, doc, samlResponse.isSigned());
        }
    }

    public void validateSamlResponse(org.opensaml.saml.saml1.core.Response samlResponse, Crypto sigCrypto, CallbackHandler callbackHandler) throws WSSecurityException {
        if (samlResponse.getStatus() == null || samlResponse.getStatus().getStatusCode() == null || samlResponse.getStatus().getStatusCode().getValue() == null) {
            LOG.fine("Either the SAML Response Status or StatusCode is null");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        String statusValue = samlResponse.getStatus().getStatusCode().getValue().getLocalPart();
        if (!SAML1_STATUSCODE_SUCCESS.equals(statusValue)) {
            LOG.fine("SAML Status code of " + samlResponse.getStatus().getStatusCode().getValue() + "does not equal " + SAML1_STATUSCODE_SUCCESS);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        if (samlResponse.getIssueInstant() != null) {
            DateTime currentTime = new DateTime();
            currentTime = currentTime.plusSeconds(this.futureTTL);
            if (samlResponse.getIssueInstant().isAfter((ReadableInstant)currentTime)) {
                LOG.fine("SAML Response IssueInstant not met");
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
            }
        }
        if (SAMLVersion.VERSION_11 != samlResponse.getVersion()) {
            LOG.fine("SAML Version of " + samlResponse.getVersion() + "does not equal " + SAMLVersion.VERSION_11);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        this.validateResponseSignature(samlResponse, sigCrypto, callbackHandler);
        for (Assertion assertion : samlResponse.getAssertions()) {
            SamlAssertionWrapper wrapper = new SamlAssertionWrapper((SAMLObject)assertion);
            this.validateAssertion(wrapper, sigCrypto, callbackHandler, samlResponse.getDOM().getOwnerDocument(), samlResponse.isSigned());
        }
    }

    private void validateResponseSignature(Response samlResponse, Crypto sigCrypto, CallbackHandler callbackHandler) throws WSSecurityException {
        if (!samlResponse.isSigned()) {
            return;
        }
        Attr idAttr = samlResponse.getDOM().getAttributeNodeNS(null, "ID");
        if (idAttr != null) {
            samlResponse.getDOM().setIdAttributeNode(idAttr, true);
        }
        this.validateResponseSignature(samlResponse.getSignature(), samlResponse.getDOM().getOwnerDocument(), sigCrypto, callbackHandler);
    }

    private void validateResponseSignature(org.opensaml.saml.saml1.core.Response samlResponse, Crypto sigCrypto, CallbackHandler callbackHandler) throws WSSecurityException {
        if (!samlResponse.isSigned()) {
            return;
        }
        Attr idAttr = samlResponse.getDOM().getAttributeNodeNS(null, "ID");
        if (idAttr != null) {
            samlResponse.getDOM().setIdAttributeNode(idAttr, true);
        }
        this.validateResponseSignature(samlResponse.getSignature(), samlResponse.getDOM().getOwnerDocument(), sigCrypto, callbackHandler);
    }

    private void validateResponseSignature(Signature signature, Document doc, Crypto sigCrypto, CallbackHandler callbackHandler) throws WSSecurityException {
        RequestData requestData = new RequestData();
        requestData.setSigVerCrypto(sigCrypto);
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        requestData.setWssConfig(wssConfig);
        requestData.setCallbackHandler(callbackHandler);
        SAMLKeyInfo samlKeyInfo = null;
        KeyInfo keyInfo = signature.getKeyInfo();
        if (keyInfo != null) {
            try {
                samlKeyInfo = SAMLUtil.getCredentialFromKeyInfo((Element)keyInfo.getDOM(), (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(requestData, new WSDocInfo(doc)), (Crypto)sigCrypto);
            }
            catch (WSSecurityException ex) {
                LOG.log(Level.FINE, "Error in getting KeyInfo from SAML Response: " + ex.getMessage(), ex);
                throw ex;
            }
        } else if (!this.keyInfoMustBeAvailable) {
            samlKeyInfo = this.createKeyInfoFromDefaultAlias(sigCrypto);
        }
        if (samlKeyInfo == null) {
            LOG.fine("No KeyInfo supplied in the SAMLResponse signature");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        this.validateSignatureAgainstProfiles(signature, samlKeyInfo);
        Credential trustCredential = new Credential();
        trustCredential.setPublicKey(samlKeyInfo.getPublicKey());
        trustCredential.setCertificates(samlKeyInfo.getCerts());
        try {
            this.signatureValidator.validate(trustCredential, requestData);
        }
        catch (WSSecurityException e) {
            LOG.log(Level.FINE, "Error in validating signature on SAML Response: " + e.getMessage(), e);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
    }

    protected SAMLKeyInfo createKeyInfoFromDefaultAlias(Crypto sigCrypto) throws WSSecurityException {
        try {
            X509Certificate[] certs = RSSecurityUtils.getCertificates((Crypto)sigCrypto, (String)sigCrypto.getDefaultX509Identifier());
            SAMLKeyInfo samlKeyInfo = new SAMLKeyInfo(new X509Certificate[]{certs[0]});
            samlKeyInfo.setPublicKey(certs[0].getPublicKey());
            return samlKeyInfo;
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Error in loading the certificates: " + ex.getMessage(), ex);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_SIGNATURE, ex);
        }
    }

    private void validateSignatureAgainstProfiles(Signature signature, SAMLKeyInfo samlKeyInfo) throws WSSecurityException {
        SAMLSignatureProfileValidator validator = new SAMLSignatureProfileValidator();
        try {
            validator.validate(signature);
        }
        catch (SignatureException ex) {
            LOG.log(Level.FINE, "Error in validating the SAML Signature: " + ex.getMessage(), ex);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        BasicX509Credential credential = null;
        if (samlKeyInfo.getCerts() != null) {
            credential = new BasicX509Credential(samlKeyInfo.getCerts()[0]);
        } else if (samlKeyInfo.getPublicKey() != null) {
            credential = new BasicCredential(samlKeyInfo.getPublicKey());
        } else {
            LOG.fine("Can't get X509Certificate or PublicKey to verify signature");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        try {
            ApacheSantuarioSignatureValidationProviderImpl responseSignatureValidator = new ApacheSantuarioSignatureValidationProviderImpl();
            responseSignatureValidator.validate(signature, (org.opensaml.security.credential.Credential)credential);
        }
        catch (SignatureException ex) {
            LOG.log(Level.FINE, "Error in validating the SAML Signature: " + ex.getMessage(), ex);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
    }

    private void validateAssertion(SamlAssertionWrapper assertion, Crypto sigCrypto, CallbackHandler callbackHandler, Document doc, boolean signedResponse) throws WSSecurityException {
        Credential credential = new Credential();
        credential.setSamlAssertion(assertion);
        RequestData requestData = new RequestData();
        requestData.setSigVerCrypto(sigCrypto);
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        requestData.setWssConfig(wssConfig);
        requestData.setCallbackHandler(callbackHandler);
        if (assertion.isSigned()) {
            if (assertion.getSaml1() != null) {
                assertion.getSaml1().getDOM().setIdAttributeNS(null, "AssertionID", true);
            } else {
                assertion.getSaml2().getDOM().setIdAttributeNS(null, "ID", true);
            }
            try {
                Signature sig = assertion.getSignature();
                WSDocInfo docInfo = new WSDocInfo(sig.getDOM().getOwnerDocument());
                SAMLKeyInfo samlKeyInfo = null;
                KeyInfo keyInfo = sig.getKeyInfo();
                if (keyInfo != null) {
                    samlKeyInfo = SAMLUtil.getCredentialFromKeyInfo((Element)keyInfo.getDOM(), (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(requestData, docInfo), (Crypto)sigCrypto);
                } else if (!this.keyInfoMustBeAvailable) {
                    samlKeyInfo = this.createKeyInfoFromDefaultAlias(sigCrypto);
                }
                if (samlKeyInfo == null) {
                    LOG.fine("No KeyInfo supplied in the SAMLResponse assertion signature");
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
                }
                assertion.verifySignature(samlKeyInfo);
                assertion.parseSubject((SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(requestData, new WSDocInfo(doc)), requestData.getSigVerCrypto(), requestData.getCallbackHandler());
            }
            catch (WSSecurityException e) {
                LOG.log(Level.FINE, "Assertion failed signature validation", e);
                throw e;
            }
        }
        try {
            SamlSSOAssertionValidator assertionValidator = new SamlSSOAssertionValidator(signedResponse);
            assertionValidator.validate(credential, requestData);
        }
        catch (WSSecurityException ex) {
            LOG.log(Level.FINE, "Assertion validation failed: " + ex.getMessage(), ex);
            throw ex;
        }
    }

    private Element decryptAssertion(EncryptedAssertion assertion, Crypto sigCrypto, CallbackHandler callbackHandler) throws WSSecurityException {
        EncryptedData encryptedData = assertion.getEncryptedData();
        Element encryptedDataDOM = encryptedData.getDOM();
        Element encKeyElement = this.getNode(assertion.getDOM(), "http://www.w3.org/2001/04/xmlenc#", "EncryptedKey", 0);
        if (encKeyElement == null) {
            encKeyElement = this.getNode(encryptedDataDOM, "http://www.w3.org/2001/04/xmlenc#", "EncryptedKey", 0);
        }
        if (encKeyElement == null) {
            LOG.log(Level.FINE, "EncryptedKey element is not available");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        X509Certificate cert = this.loadCertificate(sigCrypto, encKeyElement);
        if (cert == null) {
            LOG.fine("X509Certificate cannot be retrieved from EncryptedKey element");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        String keyEncAlgo = this.getEncodingMethodAlgorithm(encKeyElement);
        String digestAlgo = this.getDigestMethodAlgorithm(encKeyElement);
        Element cipherValue = this.getNode(encKeyElement, "http://www.w3.org/2001/04/xmlenc#", "CipherValue", 0);
        if (cipherValue == null) {
            LOG.fine("CipherValue element is not available");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        if (callbackHandler == null) {
            LOG.fine("A CallbackHandler must be configured to decrypt encrypted Assertions");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        PrivateKey key = null;
        try {
            key = sigCrypto.getPrivateKey(cert, callbackHandler);
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Encrypted key can not be decrypted", ex);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        Cipher cipher = EncryptionUtils.initCipherWithKey((String)keyEncAlgo, (String)digestAlgo, (int)2, (Key)key);
        byte[] decryptedBytes = null;
        try {
            byte[] encryptedBytes = Base64Utility.decode((String)cipherValue.getTextContent().trim());
            decryptedBytes = cipher.doFinal(encryptedBytes);
        }
        catch (Base64Exception ex) {
            LOG.log(Level.FINE, "Base64 decoding has failed", ex);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Encrypted key can not be decrypted", ex);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        String symKeyAlgo = this.getEncodingMethodAlgorithm(encryptedDataDOM);
        byte[] decryptedPayload = null;
        try {
            decryptedPayload = this.decryptPayload(encryptedDataDOM, decryptedBytes, symKeyAlgo);
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Payload can not be decrypted", ex);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        Document payloadDoc = null;
        try {
            payloadDoc = StaxUtils.read((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(decryptedPayload), StandardCharsets.UTF_8));
            return payloadDoc.getDocumentElement();
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Payload document can not be created", ex);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
    }

    private Element getNode(Element parent, String ns, String name, int index) {
        NodeList list = parent.getElementsByTagNameNS(ns, name);
        if (list != null && list.getLength() >= index + 1) {
            return (Element)list.item(index);
        }
        return null;
    }

    private X509Certificate loadCertificate(Crypto crypto, Element encKeyElement) throws WSSecurityException {
        Element certNode = this.getNode(encKeyElement, "http://www.w3.org/2000/09/xmldsig#", "X509Certificate", 0);
        if (certNode != null) {
            try {
                return RSSecurityUtils.loadX509Certificate((Crypto)crypto, (Element)certNode);
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "X509Certificate can not be created", ex);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
            }
        }
        certNode = this.getNode(encKeyElement, "http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial", 0);
        if (certNode != null) {
            try {
                return RSSecurityUtils.loadX509IssuerSerial((Crypto)crypto, (Element)certNode);
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "X509Certificate can not be created", ex);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
            }
        }
        if (crypto.getDefaultX509Identifier() != null) {
            try {
                X509Certificate[] certs = RSSecurityUtils.getCertificates((Crypto)crypto, (String)crypto.getDefaultX509Identifier());
                if (certs.length > 0) {
                    return certs[0];
                }
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "X509Certificate can not be created", ex);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
            }
        }
        return null;
    }

    private String getEncodingMethodAlgorithm(Element parent) throws WSSecurityException {
        Element encMethod = this.getNode(parent, "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod", 0);
        if (encMethod == null) {
            LOG.fine("EncryptionMethod element is not available");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        return encMethod.getAttribute("Algorithm");
    }

    private String getDigestMethodAlgorithm(Element parent) {
        Element digestMethod;
        Element encMethod = this.getNode(parent, "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod", 0);
        if (encMethod != null && (digestMethod = this.getNode(encMethod, "http://www.w3.org/2000/09/xmldsig#", "DigestMethod", 0)) != null) {
            return digestMethod.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    private byte[] decryptPayload(Element root, byte[] secretKeyBytes, String symEncAlgo) throws WSSecurityException {
        SecretKey key = KeyUtils.prepareSecretKey((String)symEncAlgo, (byte[])secretKeyBytes);
        try {
            XMLCipher xmlCipher = EncryptionUtils.initXMLCipher((String)symEncAlgo, (int)2, (Key)key);
            return xmlCipher.decryptToByteArray(root);
        }
        catch (XMLEncryptionException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)((Object)ex));
        }
    }

    public void setKeyInfoMustBeAvailable(boolean keyInfoMustBeAvailable) {
        this.keyInfoMustBeAvailable = keyInfoMustBeAvailable;
    }

    public int getFutureTTL() {
        return this.futureTTL;
    }

    public void setFutureTTL(int futureTTL) {
        this.futureTTL = futureTTL;
    }
}

