/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.dao;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.group.Group;

public class AllowedSchemas<S extends Schema> {
    private final Set<S> forSelf = new HashSet<S>();
    private final Map<Group, Set<S>> forMemberships = new HashMap<Group, Set<S>>();

    public Set<S> getForSelf() {
        return this.forSelf;
    }

    public Set<S> getForMembership(Group group) {
        return SetUtils.emptyIfNull(this.forMemberships.get(group));
    }

    public Map<Group, Set<S>> getForMemberships() {
        return this.forMemberships;
    }

    public boolean forSelfContains(S schema) {
        return this.forSelf.contains(schema);
    }

    public boolean forSelfContains(String schema) {
        return IterableUtils.matchesAny(this.forSelf, (Predicate)new KeyMatches(schema));
    }

    public boolean forMembershipsContains(Group group, S schema) {
        return IterableUtils.matchesAny((Iterable)this.forMemberships.get(group), (Predicate)PredicateUtils.equalPredicate(schema));
    }

    public boolean forMembershipsContains(S schema) {
        for (Map.Entry<Group, Set<S>> entry : this.forMemberships.entrySet()) {
            if (!entry.getValue().contains(schema)) continue;
            return true;
        }
        return false;
    }

    public boolean forMembershipsContains(Group group, String schema) {
        return IterableUtils.matchesAny((Iterable)this.forMemberships.get(group), (Predicate)new KeyMatches(schema));
    }

    public boolean forMembershipsContains(String schema) {
        KeyMatches keyMatches = new KeyMatches(schema);
        for (Map.Entry<Group, Set<S>> entry : this.forMemberships.entrySet()) {
            if (!IterableUtils.matchesAny((Iterable)entry.getValue(), (Predicate)keyMatches)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(S schema) {
        if (this.forSelfContains(schema)) {
            return true;
        }
        return this.forMembershipsContains(schema);
    }

    public boolean contains(String schema) {
        if (this.forSelfContains(schema)) {
            return true;
        }
        return this.forMembershipsContains(schema);
    }

    private class KeyMatches
    implements Predicate<S> {
        private final String schema;

        KeyMatches(String schema) {
            this.schema = schema;
        }

        public boolean evaluate(S object) {
            return object.getKey().equals(this.schema);
        }
    }
}

