/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.attrvalue.validation;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ValidationException;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.types.EntityViolationType;

public class InvalidEntityException
extends ValidationException {
    private static final long serialVersionUID = 3249297275444409691L;
    private final String entityClassSimpleName;
    private final Map<Class<?>, Set<EntityViolationType>> violations = new HashMap();

    public InvalidEntityException(Class<?> entityClass, EntityViolationType entityViolationType, String message) {
        this.entityClassSimpleName = entityClass.getSimpleName();
        entityViolationType.setMessage(message.trim());
        this.violations.put(entityClass, EnumSet.noneOf(EntityViolationType.class));
        this.violations.get(entityClass).add(entityViolationType);
    }

    public InvalidEntityException(String entityClassSimpleName, Set<ConstraintViolation<Object>> violations) {
        this.entityClassSimpleName = entityClassSimpleName;
        for (ConstraintViolation<Object> violation : violations) {
            EntityViolationType entityViolationType;
            int firstComma = violation.getMessageTemplate().indexOf(59);
            String key = violation.getMessageTemplate().substring(0, firstComma > 0 ? firstComma : violation.getMessageTemplate().length());
            String message = violation.getMessageTemplate().substring(firstComma > 0 ? firstComma + 1 : 0);
            try {
                entityViolationType = EntityViolationType.valueOf((String)key.trim());
            }
            catch (IllegalArgumentException e) {
                entityViolationType = EntityViolationType.Standard;
            }
            entityViolationType.setMessage(message.trim());
            if (!this.violations.containsKey(violation.getLeafBean().getClass())) {
                this.violations.put(violation.getLeafBean().getClass(), EnumSet.noneOf(EntityViolationType.class));
            }
            this.violations.get(violation.getLeafBean().getClass()).add(entityViolationType);
        }
    }

    public final boolean hasViolation(final EntityViolationType type) {
        return IterableUtils.matchesAny(this.violations.keySet(), (Predicate)new Predicate<Class<?>>(){

            public boolean evaluate(Class<?> entity) {
                return ((Set)InvalidEntityException.this.violations.get(entity)).contains(type);
            }
        });
    }

    public String getEntityClassSimpleName() {
        return this.entityClassSimpleName;
    }

    public final Map<Class<?>, Set<EntityViolationType>> getViolations() {
        return this.violations;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Class<?>, Set<EntityViolationType>> entry : this.violations.entrySet()) {
            sb.append(entry.getKey().getSimpleName()).append(' ').append(entry.getValue().toString()).append(", ");
        }
        sb.delete(sb.lastIndexOf(", "), sb.length());
        return sb.toString();
    }
}

