/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.optional.servlet.components.sax.serializers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.cocoon.components.serializers.util.HTMLSerializer;
import org.apache.cocoon.optional.servlet.components.sax.serializers.util.ConfigurationUtils;
import org.apache.cocoon.pipeline.SetupException;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.ParameterCacheKey;
import org.apache.cocoon.pipeline.component.CachingPipelineComponent;
import org.apache.cocoon.pipeline.component.Finisher;
import org.apache.cocoon.pipeline.util.StringRepresentation;
import org.apache.cocoon.sax.SAXConsumer;
import org.apache.cocoon.sax.SAXPipelineComponent;
import org.apache.cocoon.servlet.util.HttpContextHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodingHTMLSerializer
extends HTMLSerializer
implements SAXPipelineComponent,
Finisher,
SAXConsumer,
CachingPipelineComponent {
    private String encoding;
    private int indent = 0;
    private String docType;

    public CacheKey constructCacheKey() {
        ParameterCacheKey parameterCacheKey = new ParameterCacheKey();
        parameterCacheKey.addParameter("encoding", this.encoding);
        parameterCacheKey.addParameter("indent", this.indent);
        parameterCacheKey.addParameter("docType", this.docType);
        return parameterCacheKey;
    }

    public void finish() {
    }

    public String getContentType() {
        return this.getMimeType();
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        try {
            this.encoding = ConfigurationUtils.getEncoding(configuration);
            this.setEncoding(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SetupException((Throwable)e);
        }
        try {
            this.indent = ConfigurationUtils.getIndent(configuration);
            this.setIndentPerLevel(this.indent);
        }
        catch (NumberFormatException nfe) {
            throw new SetupException((Throwable)nfe);
        }
        this.docType = (String)configuration.get("doctype-default");
        this.setDoctypeDefault(this.docType);
    }

    public void setOutputStream(OutputStream outputStream) {
        try {
            super.setOutputStream(outputStream);
        }
        catch (IOException e) {
            throw new SetupException((Throwable)e);
        }
    }

    public void setup(Map<String, Object> parameters) {
        this.setup(HttpContextHelper.getRequest(parameters));
    }

    public String toString() {
        return StringRepresentation.buildString((Object)((Object)this), (String[])new String[0]);
    }
}

