/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.ClientExceptionType;

public class SyncopeClientCompositeException
extends SyncopeClientException {
    private static final long serialVersionUID = 7882118041134372129L;
    private final Set<SyncopeClientException> exceptions = new HashSet<SyncopeClientException>();

    protected SyncopeClientCompositeException() {
        super(ClientExceptionType.Composite);
    }

    public boolean hasExceptions() {
        return !this.exceptions.isEmpty();
    }

    public boolean hasException(ClientExceptionType exceptionType) {
        return this.getException(exceptionType) != null;
    }

    public SyncopeClientException getException(ClientExceptionType exceptionType) {
        boolean found = false;
        SyncopeClientException syncopeClientException = null;
        Iterator<SyncopeClientException> itor = this.exceptions.iterator();
        while (itor.hasNext() && !found) {
            syncopeClientException = itor.next();
            if (!syncopeClientException.getType().equals((Object)exceptionType)) continue;
            found = true;
        }
        return found ? syncopeClientException : null;
    }

    public Set<SyncopeClientException> getExceptions() {
        return this.exceptions;
    }

    public boolean addException(final SyncopeClientException exception) {
        if (exception.getType() == null) {
            throw new IllegalArgumentException(exception + " does not have the right " + ClientExceptionType.class.getName() + " set");
        }
        SyncopeClientException alreadyAdded = (SyncopeClientException)IterableUtils.find(this.exceptions, (Predicate)new Predicate<SyncopeClientException>(){

            public boolean evaluate(SyncopeClientException ex) {
                return ex.getType() == exception.getType();
            }
        });
        return alreadyAdded == null ? this.exceptions.add(exception) : alreadyAdded.getElements().addAll(exception.getElements());
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append('{');
        Iterator<SyncopeClientException> iter = this.getExceptions().iterator();
        while (iter.hasNext()) {
            SyncopeClientException e = iter.next();
            message.append('[').append(e.getMessage()).append(']');
            if (!iter.hasNext()) continue;
            message.append(", ");
        }
        message.append('}');
        return message.toString();
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }
}

