/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.server.impl;

import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.api.ConnectorFacade;
import org.identityconnectors.framework.api.ConnectorFacadeFactory;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.api.ConnectorInfoManager;
import org.identityconnectors.framework.api.ConnectorInfoManagerFactory;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;
import org.identityconnectors.framework.common.serializer.SerializerUtil;
import org.identityconnectors.framework.impl.api.ConnectorInfoManagerFactoryImpl;
import org.identityconnectors.framework.impl.api.ObjectStreamHandler;
import org.identityconnectors.framework.impl.api.StreamHandlerUtil;
import org.identityconnectors.framework.impl.api.local.LocalConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.remote.RemoteConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.remote.RemoteFrameworkConnection;
import org.identityconnectors.framework.impl.api.remote.messages.EchoMessage;
import org.identityconnectors.framework.impl.api.remote.messages.HelloRequest;
import org.identityconnectors.framework.impl.api.remote.messages.HelloResponse;
import org.identityconnectors.framework.impl.api.remote.messages.OperationRequest;
import org.identityconnectors.framework.impl.api.remote.messages.OperationRequestMoreData;
import org.identityconnectors.framework.impl.api.remote.messages.OperationResponseEnd;
import org.identityconnectors.framework.impl.api.remote.messages.OperationResponsePart;
import org.identityconnectors.framework.impl.api.remote.messages.OperationResponsePause;
import org.identityconnectors.framework.server.ConnectorServer;
import org.identityconnectors.framework.server.impl.ConnectionListener;

public class ConnectionProcessor
implements Runnable {
    private static final Log LOG = Log.getLog(ConnectionListener.class);
    private final ConnectorServer connectorServer;
    private final RemoteFrameworkConnection connection;

    public ConnectionProcessor(ConnectorServer server, Socket socket) {
        this.connectorServer = server;
        this.connection = new RemoteFrameworkConnection(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                boolean keepGoing;
                while (keepGoing = this.processRequest()) {
                }
            }
            finally {
                try {
                    this.connection.close();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, null, new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            LOG.error(e, null, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processRequest() throws Exception {
        Object requestObject;
        boolean authorized;
        Locale locale;
        try {
            locale = (Locale)this.connection.readObject();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof EOFException) {
                return false;
            }
            throw e;
        }
        CurrentLocale.set((Locale)locale);
        GuardedString key = (GuardedString)this.connection.readObject();
        try {
            authorized = key.verifyBase64SHA1Hash(this.connectorServer.getKeyHash());
        }
        finally {
            key.dispose();
        }
        InvalidCredentialException authException = null;
        if (!authorized) {
            authException = new InvalidCredentialException("Remote framework key is invalid");
        }
        if ((requestObject = this.connection.readObject()) instanceof HelloRequest) {
            if (authException != null) {
                HelloResponse response = new HelloResponse((Throwable)authException, null, null, null);
                this.connection.writeObject(response);
            } else {
                HelloResponse response = this.processHelloRequest((HelloRequest)requestObject);
                this.connection.writeObject(response);
            }
        } else if (requestObject instanceof OperationRequest) {
            if (authException != null) {
                OperationResponsePart part = new OperationResponsePart((Throwable)authException, null);
                this.connection.writeObject(part);
            } else {
                OperationRequest opRequest = (OperationRequest)requestObject;
                OperationResponsePart part = this.processOperationRequest(opRequest);
                this.connection.writeObject(part);
            }
        } else if (requestObject instanceof EchoMessage) {
            if (authException != null) {
                EchoMessage part = new EchoMessage(authException, null);
                this.connection.writeObject(part);
            } else {
                EchoMessage message = (EchoMessage)requestObject;
                Object obj = message.getObject();
                String xml = message.getXml();
                if (xml != null) {
                    Object xmlClone = SerializerUtil.deserializeXmlObject((String)xml, (boolean)true);
                    xml = SerializerUtil.serializeXmlObject((Object)xmlClone, (boolean)true);
                }
                EchoMessage message2 = new EchoMessage(obj, xml);
                this.connection.writeObject(message2);
            }
        } else {
            throw new ConnectorException("Unexpected request: " + requestObject);
        }
        return true;
    }

    private ConnectorInfoManager getConnectorInfoManager() {
        ConnectorInfoManagerFactoryImpl factory = (ConnectorInfoManagerFactoryImpl)ConnectorInfoManagerFactory.getInstance();
        return factory.getLocalManager(this.connectorServer.getBundleURLs(), this.connectorServer.getBundleParentClassLoader());
    }

    private HelloResponse processHelloRequest(HelloRequest request) {
        ArrayList<RemoteConnectorInfoImpl> connectorInfo = null;
        ArrayList<ConnectorKey> connectorKeys = null;
        HashMap<String, Object> serverInfo = null;
        Exception exception = null;
        try {
            serverInfo = new HashMap<String, Object>(1);
            if (request.isServerInfo()) {
                serverInfo.put("SERVER_START_TIME", this.connectorServer.getStartTime());
            }
            if (request.isConnectorKeys()) {
                ConnectorInfoManager manager = this.getConnectorInfoManager();
                List localInfos = manager.getConnectorInfos();
                connectorKeys = new ArrayList<ConnectorKey>();
                for (ConnectorInfo localInfo : localInfos) {
                    connectorKeys.add(localInfo.getConnectorKey());
                }
                if (request.isConnectorInfo()) {
                    connectorInfo = new ArrayList<RemoteConnectorInfoImpl>();
                    for (ConnectorInfo localInfo : localInfos) {
                        LocalConnectorInfoImpl localInfoImpl = (LocalConnectorInfoImpl)localInfo;
                        RemoteConnectorInfoImpl remoteInfo = localInfoImpl.toRemote();
                        connectorInfo.add(remoteInfo);
                    }
                }
            }
        }
        catch (Exception e) {
            exception = e;
            connectorInfo = null;
        }
        return new HelloResponse(exception, serverInfo, connectorKeys, connectorInfo);
    }

    private Method getOperationMethod(OperationRequest request) {
        Method[] methods = request.getOperation().getDeclaredMethods();
        Method found = null;
        for (Method m : methods) {
            if (!m.getName().equalsIgnoreCase(request.getOperationMethodName())) continue;
            if (found != null) {
                throw new ConnectorException("APIOperations are expected to have exactly one method of a given name: " + request.getOperation());
            }
            found = m;
        }
        if (found == null) {
            throw new ConnectorException("APIOperations are expected to have exactly one method of a given name: " + request.getOperation());
        }
        return found;
    }

    private OperationResponsePart processOperationRequest(OperationRequest request) throws IOException {
        Object result;
        Throwable exception;
        block8: {
            exception = null;
            try {
                boolean anyStreams;
                Method method = this.getOperationMethod(request);
                APIOperation operation = this.getAPIOperation(request);
                List<Object> arguments = request.getArguments();
                List<Object> argumentsAndStreamHandlers = this.populateStreamHandlers(method.getParameterTypes(), arguments);
                try {
                    result = method.invoke((Object)operation, argumentsAndStreamHandlers.toArray());
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
                boolean bl = anyStreams = argumentsAndStreamHandlers.size() > arguments.size();
                if (!anyStreams) break block8;
                try {
                    this.connection.writeObject(new OperationResponseEnd());
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof IOException) {
                        throw new BrokenConnectionException((IOException)e.getCause());
                    }
                    throw e;
                }
            }
            catch (BrokenConnectionException w) {
                throw w.getIOException();
            }
            catch (Throwable e) {
                LOG.error(e, null, new Object[0]);
                exception = e;
                result = null;
            }
        }
        return new OperationResponsePart(exception, result);
    }

    private List<Object> populateStreamHandlers(Class<?>[] paramTypes, List<Object> arguments) {
        ArrayList<Object> rv = new ArrayList<Object>();
        boolean firstStream = true;
        Iterator<Object> argIt = arguments.iterator();
        for (Class<?> paramType : paramTypes) {
            if (StreamHandlerUtil.isAdaptableToObjectStreamHandler(paramType)) {
                if (!firstStream) {
                    throw new UnsupportedOperationException("At most one stream handler is supported");
                }
                RemoteResultsHandler osh = new RemoteResultsHandler(this.connection);
                rv.add(StreamHandlerUtil.adaptFromObjectStreamHandler(paramType, osh));
                firstStream = false;
                continue;
            }
            rv.add(argIt.next());
        }
        return rv;
    }

    private APIOperation getAPIOperation(OperationRequest request) throws Exception {
        ConnectorInfoManager manager = this.getConnectorInfoManager();
        ConnectorInfo info = manager.findConnectorInfo(request.getConnectorKey());
        if (info == null) {
            throw new ConnectorException("No such connector: " + request.getConnectorKey() + " ");
        }
        String connectorFacadeKey = request.getConnectorFacadeKey();
        ConnectorFacade facade = ConnectorFacadeFactory.getManagedInstance().newInstance(info, connectorFacadeKey);
        return facade.getOperation(request.getOperation());
    }

    private static class BrokenConnectionException
    extends ConnectorException {
        static final long serialVersionUID = 0L;

        public BrokenConnectionException(IOException ex) {
            super((Throwable)ex);
        }

        public IOException getIOException() {
            return (IOException)this.getCause();
        }
    }

    private static class RemoteResultsHandler
    implements ObjectStreamHandler {
        private static final int PAUSE_INTERVAL = 200;
        private final RemoteFrameworkConnection connection;
        private long count = 0L;

        public RemoteResultsHandler(RemoteFrameworkConnection conn) {
            this.connection = conn;
        }

        @Override
        public boolean handle(Object obj) {
            try {
                OperationResponsePart part = new OperationResponsePart(null, obj);
                this.connection.writeObject(part);
                ++this.count;
                if (this.count % 200L == 0L) {
                    this.connection.writeObject(new OperationResponsePause());
                    Object message = this.connection.readObject();
                    return message instanceof OperationRequestMoreData;
                }
                return true;
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw new BrokenConnectionException((IOException)e.getCause());
                }
                throw e;
            }
        }
    }
}

