/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.remote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.event.ConnectorEvent;
import org.identityconnectors.common.event.ConnectorEventHandler;
import org.identityconnectors.common.event.ConnectorEventPublisher;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.api.ConnectorInfoManager;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.api.RemoteFrameworkConnectionInfo;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.ConnectorIOException;
import org.identityconnectors.framework.common.serializer.SerializerUtil;
import org.identityconnectors.framework.impl.api.remote.RemoteConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.remote.RemoteFrameworkConnection;
import org.identityconnectors.framework.impl.api.remote.messages.HelloRequest;
import org.identityconnectors.framework.impl.api.remote.messages.HelloResponse;

public class RemoteConnectorInfoManagerImpl
implements ConnectorInfoManager,
ConnectorEventPublisher,
Runnable {
    private static final Log LOG = Log.getLog(RemoteConnectorInfoManagerImpl.class);
    private final RemoteFrameworkConnectionInfo frameworkConnectionInfo;
    private List<ConnectorInfo> connectorInfoList;
    private Long serverStartTime = null;
    private final Vector<ConnectorEventHandler> eventHandlers = new Vector();

    private RemoteConnectorInfoManagerImpl() {
        this.frameworkConnectionInfo = null;
    }

    public RemoteConnectorInfoManagerImpl(RemoteFrameworkConnectionInfo info) throws RuntimeException {
        this(info, true);
    }

    public RemoteConnectorInfoManagerImpl(RemoteFrameworkConnectionInfo info, boolean loadConnectorInfo) throws RuntimeException {
        this.frameworkConnectionInfo = info;
        if (loadConnectorInfo) {
            this.init();
        } else {
            this.connectorInfoList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        RemoteFrameworkConnection connection = new RemoteFrameworkConnection(this.frameworkConnectionInfo);
        HelloResponse response = null;
        try {
            connection.writeObject(CurrentLocale.get());
            connection.writeObject(this.frameworkConnectionInfo.getKey());
            connection.writeObject(new HelloRequest(20));
            response = (HelloResponse)connection.readObject();
        }
        finally {
            connection.close();
        }
        if (null == response) {
            LOG.error("HelloResponse is null from {0}", new Object[]{this.frameworkConnectionInfo});
            throw new ConnectorIOException("HelloResponse is null from " + this.frameworkConnectionInfo.toString());
        }
        if (response.getException() != null) {
            throw ConnectorException.wrap((Throwable)response.getException());
        }
        List<RemoteConnectorInfoImpl> remoteInfos = response.getConnectorInfos();
        for (RemoteConnectorInfoImpl remoteInfo : remoteInfos) {
            remoteInfo.setRemoteConnectionInfo(this.frameworkConnectionInfo);
        }
        List<ConnectorInfo> connectorInfoBefore = this.connectorInfoList;
        this.connectorInfoList = CollectionUtil.newReadOnlyList(remoteInfos);
        Object o = response.getServerInfo().get("SERVER_START_TIME");
        this.serverStartTime = o instanceof Long ? (Long)o : Long.valueOf(System.currentTimeMillis());
        ArrayList<ConnectorInfo> unchanged = new ArrayList<ConnectorInfo>(this.connectorInfoList.size());
        if (null != connectorInfoBefore) {
            for (ConnectorInfo oldCi : connectorInfoBefore) {
                boolean unregistered = true;
                for (ConnectorInfo newCi : this.connectorInfoList) {
                    if (!oldCi.getConnectorKey().equals((Object)newCi.getConnectorKey())) continue;
                    unregistered = false;
                    unchanged.add(newCi);
                    break;
                }
                if (!unregistered) continue;
                this.notifyListeners(new ConnectorEvent("ORG_FORGEROCK_OPENICF_CONNECTOREVENT-UNREGISTERING", oldCi.getConnectorKey()));
            }
        }
        for (ConnectorInfo newCi : this.connectorInfoList) {
            if (unchanged.contains(newCi)) continue;
            this.notifyListeners(new ConnectorEvent("ORG_FORGEROCK_OPENICF_CONNECTOREVENT-REGISTERED", newCi.getConnectorKey()));
        }
    }

    public RemoteConnectorInfoManagerImpl derive(RemoteFrameworkConnectionInfo info) {
        RemoteConnectorInfoManagerImpl rv = new RemoteConnectorInfoManagerImpl();
        if (null == this.connectorInfoList || this.connectorInfoList.isEmpty()) {
            rv.connectorInfoList = Collections.emptyList();
        } else {
            List remoteInfos = (List)SerializerUtil.cloneObject(this.connectorInfoList);
            for (RemoteConnectorInfoImpl remoteInfo : remoteInfos) {
                remoteInfo.setRemoteConnectionInfo(info);
            }
            rv.connectorInfoList = CollectionUtil.newReadOnlyList((List)remoteInfos);
        }
        return rv;
    }

    public ConnectorInfo findConnectorInfo(ConnectorKey key) {
        for (ConnectorInfo info : this.getConnectorInfos()) {
            if (!info.getConnectorKey().equals((Object)key)) continue;
            return info;
        }
        return null;
    }

    public List<ConnectorInfo> getConnectorInfos() {
        List<Object> result = this.connectorInfoList;
        if (null == result) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public void run() {
        try {
            Map<String, Object> serverInfo = this.getServerInfo();
            Object o = serverInfo.get("SERVER_START_TIME");
            if (o instanceof Long && (null == this.serverStartTime || (Long)o > this.serverStartTime)) {
                if (LOG.isOk()) {
                    if (null != this.serverStartTime) {
                        LOG.ok("Connector server has been restarted since {0}, new start time: {1}", new Object[]{new Date(this.serverStartTime), new Date((Long)o)});
                    } else {
                        LOG.ok("First connection to connector server has been established, new start time: {0}", new Object[]{new Date((Long)o)});
                    }
                }
                this.init();
            }
        }
        catch (ConnectorIOException e) {
            if (null != this.connectorInfoList) {
                for (ConnectorInfo connectorInfo : this.connectorInfoList) {
                    this.notifyListeners(new ConnectorEvent("ORG_FORGEROCK_OPENICF_CONNECTOREVENT-UNREGISTERING", connectorInfo.getConnectorKey()));
                }
            }
            this.connectorInfoList = null;
            LOG.error("Failed to connect to remote connector server {0}", new Object[]{this.frameworkConnectionInfo});
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Failed to update the ConnectorInfo from remote connector server", new Object[0]);
        }
    }

    public void addConnectorEventHandler(ConnectorEventHandler hook) {
        if (hook == null) {
            throw new NullPointerException();
        }
        if (!this.eventHandlers.contains(hook)) {
            if (null != this.connectorInfoList) {
                for (ConnectorInfo connectorInfo : this.connectorInfoList) {
                    hook.handleEvent(new ConnectorEvent("ORG_FORGEROCK_OPENICF_CONNECTOREVENT-REGISTERED", connectorInfo.getConnectorKey()));
                }
            }
            this.eventHandlers.addElement(hook);
        }
    }

    public void deleteConnectorEventHandler(ConnectorEventHandler hook) {
        this.eventHandlers.removeElement(hook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getServerInfo() throws RuntimeException {
        RemoteFrameworkConnection connection = new RemoteFrameworkConnection(this.frameworkConnectionInfo);
        try {
            connection.writeObject(CurrentLocale.get());
            connection.writeObject(this.frameworkConnectionInfo.getKey());
            connection.writeObject(new HelloRequest(4));
            HelloResponse response = (HelloResponse)connection.readObject();
            if (response.getException() instanceof ConnectorException) {
                throw (ConnectorException)response.getException();
            }
            if (response.getException() != null) {
                throw ConnectorException.wrap((Throwable)response.getException());
            }
            Map<String, Object> map = response.getServerInfo();
            return map;
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnectorKey> getConnectorKeys() throws RuntimeException {
        RemoteFrameworkConnection connection = new RemoteFrameworkConnection(this.frameworkConnectionInfo);
        try {
            connection.writeObject(CurrentLocale.get());
            connection.writeObject(this.frameworkConnectionInfo.getKey());
            connection.writeObject(new HelloRequest(16));
            HelloResponse response = (HelloResponse)connection.readObject();
            if (response.getException() instanceof ConnectorException) {
                throw (ConnectorException)response.getException();
            }
            if (response.getException() != null) {
                throw ConnectorException.wrap((Throwable)response.getException());
            }
            List<ConnectorKey> list = response.getConnectorKeys();
            return list;
        }
        finally {
            connection.close();
        }
    }

    private void notifyListeners(ConnectorEvent event) {
        Object[] arrLocal = this.eventHandlers.toArray();
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            try {
                ((ConnectorEventHandler)arrLocal[i]).handleEvent(new ConnectorEvent(event));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

