/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterVisitor;
import org.identityconnectors.framework.spi.SearchResultsHandler;

public final class FilteredResultsHandler
implements SearchResultsHandler {
    private final ResultsHandler handler;
    private final Filter filter;
    private final boolean inValidationMode;

    public FilteredResultsHandler(ResultsHandler handler, Filter filter) {
        this(handler, filter, false);
    }

    public FilteredResultsHandler(ResultsHandler handler, Filter filter, boolean inValidationMode) {
        if (handler == null) {
            throw new IllegalArgumentException("Handler must not be null!");
        }
        this.handler = handler;
        this.inValidationMode = inValidationMode;
        this.filter = filter == null ? new PassThroughFilter() : filter;
    }

    public void handleResult(SearchResult result) {
        if (this.handler instanceof SearchResultsHandler) {
            ((SearchResultsHandler)SearchResultsHandler.class.cast(this.handler)).handleResult(result);
        }
    }

    public boolean handle(ConnectorObject object) {
        if (this.filter.accept(object)) {
            return this.handler.handle(object);
        }
        if (this.inValidationMode) {
            throw new IllegalStateException("Object " + object + " was returned by the connector but failed to pass " + "the framework filter. This seems like wrong implementation of the filter in the connector.");
        }
        return true;
    }

    public static class PassThroughFilter
    implements Filter {
        public boolean accept(ConnectorObject obj) {
            return true;
        }

        public <R, P> R accept(FilterVisitor<R, P> v, P p) {
            return (R)v.visitExtendedFilter(p, (Filter)this);
        }
    }
}

