/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.util.HashSet;
import java.util.Set;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorAPIOperationRunner;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.ObjectNormalizerFacade;
import org.identityconnectors.framework.impl.api.local.operations.SpiOperationLoggingUtil;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.operations.CreateOp;

public class CreateImpl
extends ConnectorAPIOperationRunner
implements CreateApiOp {
    private static final Log OP_LOG = Log.getLog(CreateOp.class);

    public CreateImpl(ConnectorOperationalContext context, Connector connector) {
        super(context, connector);
    }

    public Uid create(ObjectClass objectClass, Set<Attribute> createAttributes, OperationOptions options) {
        Uid connectorUid;
        Assertions.nullCheck((Object)objectClass, (String)"objectClass");
        if (ObjectClass.ALL.equals((Object)objectClass)) {
            throw new UnsupportedOperationException("Operation is not allowed on __ALL__ object class");
        }
        Assertions.nullCheck(createAttributes, (String)"createAttributes");
        if (AttributeUtil.getUidAttribute(createAttributes) != null) {
            throw new InvalidAttributeValueException("Parameter 'createAttributes' contains a uid.");
        }
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        HashSet<String> dups = new HashSet<String>();
        for (Attribute attr : createAttributes) {
            if (dups.contains(attr.getName())) {
                throw new InvalidAttributeValueException("Duplicate attribute name exits: " + attr.getName());
            }
            dups.add(attr.getName());
        }
        Connector connector = this.getConnector();
        ObjectNormalizerFacade normalizer = this.getNormalizer(objectClass);
        Set<Attribute> normalizedAttributes = normalizer.normalizeAttributes(createAttributes);
        if (CreateImpl.isLoggable()) {
            StringBuilder bld = new StringBuilder();
            bld.append("Enter: create(");
            bld.append(objectClass).append(", ");
            bld.append(normalizedAttributes).append(", ");
            bld.append(options).append(")");
            String msg = bld.toString();
            OP_LOG.log(CreateOp.class, "create", SpiOperationLoggingUtil.LOG_LEVEL, msg, null);
        }
        try {
            connectorUid = ((CreateOp)connector).create(objectClass, normalizedAttributes, options);
        }
        catch (RuntimeException e) {
            SpiOperationLoggingUtil.logOpException(OP_LOG, CreateOp.class, "create", e);
            throw e;
        }
        if (CreateImpl.isLoggable()) {
            OP_LOG.log(CreateOp.class, "create", SpiOperationLoggingUtil.LOG_LEVEL, "Return: " + connectorUid, null);
        }
        Uid uid = (Uid)normalizer.normalizeAttribute((Attribute)connectorUid);
        return uid;
    }

    private static boolean isLoggable() {
        return OP_LOG.isLoggable(SpiOperationLoggingUtil.LOG_LEVEL);
    }
}

