/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.api.operations.AuthenticationApiOp;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorAPIOperationRunner;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.SpiOperationLoggingUtil;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.operations.AuthenticateOp;

public class AuthenticationImpl
extends ConnectorAPIOperationRunner
implements AuthenticationApiOp {
    private static final Log OP_LOG = Log.getLog(AuthenticateOp.class);

    public AuthenticationImpl(ConnectorOperationalContext context, Connector connector) {
        super(context, connector);
    }

    public Uid authenticate(ObjectClass objectClass, String username, GuardedString password, OperationOptions options) {
        Uid uid;
        Assertions.nullCheck((Object)objectClass, (String)"objectClass");
        if (ObjectClass.ALL.equals((Object)objectClass)) {
            throw new UnsupportedOperationException("Operation is not allowed on __ALL__ object class");
        }
        Assertions.nullCheck((Object)username, (String)"username");
        Assertions.nullCheck((Object)password, (String)"password");
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        if (AuthenticationImpl.isLoggable()) {
            StringBuilder bld = new StringBuilder();
            bld.append("Enter: authenticate(");
            bld.append(objectClass).append(", ");
            bld.append(username).append(", ");
            bld.append(password).append(", ");
            bld.append(options).append(")");
            String msg = bld.toString();
            OP_LOG.log(AuthenticateOp.class, "authenticate", SpiOperationLoggingUtil.LOG_LEVEL, msg, null);
        }
        try {
            uid = ((AuthenticateOp)this.getConnector()).authenticate(objectClass, username, password, options);
        }
        catch (RuntimeException e) {
            SpiOperationLoggingUtil.logOpException(OP_LOG, AuthenticateOp.class, "authenticate", e);
            throw e;
        }
        if (AuthenticationImpl.isLoggable()) {
            OP_LOG.log(AuthenticateOp.class, "authenticate", SpiOperationLoggingUtil.LOG_LEVEL, "Return: " + uid, null);
        }
        return uid;
    }

    private static boolean isLoggable() {
        return OP_LOG.isLoggable(SpiOperationLoggingUtil.LOG_LEVEL);
    }
}

