/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.impl.api.LoggingProxy;
import org.identityconnectors.framework.spi.SearchResultsHandler;

public class SearchResultsHandlerLoggingProxy
implements SearchResultsHandler {
    private static final Log LOG = Log.getLog(SearchResultsHandlerLoggingProxy.class);
    private final ResultsHandler origHandler;

    public SearchResultsHandlerLoggingProxy(ResultsHandler origHandler) {
        this.origHandler = origHandler;
    }

    public ResultsHandler getOrigHandler() {
        return this.origHandler;
    }

    public void handleResult(SearchResult result) {
        if (this.origHandler instanceof SearchResultsHandler) {
            LOG.log(SearchResultsHandler.class, "handleResult", LoggingProxy.LOG_LEVEL, "Enter: " + result, null);
            try {
                ((SearchResultsHandler)SearchResultsHandler.class.cast(this.origHandler)).handleResult(result);
                LOG.log(SearchResultsHandler.class, "handleResult", LoggingProxy.LOG_LEVEL, "Return: ", null);
            }
            catch (RuntimeException e) {
                LOG.log(SearchResultsHandler.class, "handleResult", LoggingProxy.LOG_LEVEL, "Exception: ", (Throwable)e);
                throw e;
            }
        }
    }

    public boolean handle(ConnectorObject connectorObject) {
        LOG.log(ResultsHandler.class, "handle", LoggingProxy.LOG_LEVEL, "Enter: " + connectorObject, null);
        try {
            boolean ret = this.origHandler.handle(connectorObject);
            LOG.log(ResultsHandler.class, "handle", LoggingProxy.LOG_LEVEL, "Return: " + ret, null);
            return ret;
        }
        catch (RuntimeException e) {
            LOG.log(ResultsHandler.class, "handle", LoggingProxy.LOG_LEVEL, "Exception: ", (Throwable)e);
            throw e;
        }
    }
}

