/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.common.lib.policy.AccountRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.core.logic.audit.AuditAppender;
import org.apache.syncope.core.persistence.api.ImplementationLookup;
import org.apache.syncope.core.persistence.api.attrvalue.validation.Validator;
import org.apache.syncope.core.persistence.api.dao.AccountRule;
import org.apache.syncope.core.persistence.api.dao.AccountRuleConfClass;
import org.apache.syncope.core.persistence.api.dao.PasswordRule;
import org.apache.syncope.core.persistence.api.dao.PasswordRuleConfClass;
import org.apache.syncope.core.persistence.api.dao.Reportlet;
import org.apache.syncope.core.persistence.api.dao.ReportletConfClass;
import org.apache.syncope.core.provisioning.api.LogicActions;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.job.SchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.api.notification.NotificationRecipientsProvider;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.PullCorrelationRule;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.ReconciliationFilterBuilder;
import org.apache.syncope.core.provisioning.java.data.JEXLItemTransformerImpl;
import org.apache.syncope.core.provisioning.java.job.GroupMemberProvisionTaskJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.PlainAttrsPullCorrelationRule;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.apache.syncope.core.spring.security.JWTSSOProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class ClassPathScanImplementationLookup
implements ImplementationLookup {
    private static final Logger LOG = LoggerFactory.getLogger(ImplementationLookup.class);
    private static final String DEFAULT_BASE_PACKAGE = "org.apache.syncope.core";
    private Map<ImplementationLookup.Type, Set<String>> classNames;
    private Set<Class<?>> jwtSSOProviderClasses;
    private Map<Class<? extends ReportletConf>, Class<? extends Reportlet>> reportletClasses;
    private Map<Class<? extends AccountRuleConf>, Class<? extends AccountRule>> accountRuleClasses;
    private Map<Class<? extends PasswordRuleConf>, Class<? extends PasswordRule>> passwordRuleClasses;
    private Set<Class<?>> auditAppenderClasses;

    public Integer getPriority() {
        return Integer.MIN_VALUE;
    }

    protected String getBasePackage() {
        return DEFAULT_BASE_PACKAGE;
    }

    public void load() {
        this.classNames = new EnumMap<ImplementationLookup.Type, Set<String>>(ImplementationLookup.Type.class);
        for (ImplementationLookup.Type type : ImplementationLookup.Type.values()) {
            this.classNames.put(type, new HashSet());
        }
        this.jwtSSOProviderClasses = new HashSet();
        this.reportletClasses = new HashMap<Class<? extends ReportletConf>, Class<? extends Reportlet>>();
        this.accountRuleClasses = new HashMap<Class<? extends AccountRuleConf>, Class<? extends AccountRule>>();
        this.passwordRuleClasses = new HashMap<Class<? extends PasswordRuleConf>, Class<? extends PasswordRule>>();
        this.auditAppenderClasses = new HashSet();
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(JWTSSOProvider.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Reportlet.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AccountRule.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(PasswordRule.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(ItemTransformer.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(SchedTaskJobDelegate.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(ReconciliationFilterBuilder.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(LogicActions.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(PropagationActions.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(PullActions.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(PushActions.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(PullCorrelationRule.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Validator.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(NotificationRecipientsProvider.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AuditAppender.class));
        for (BeanDefinition bd : scanner.findCandidateComponents(this.getBasePackage())) {
            try {
                ReportletConfClass annotation;
                Class clazz = ClassUtils.resolveClassName((String)bd.getBeanClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                boolean isAbstractClazz = Modifier.isAbstract(clazz.getModifiers());
                if (JWTSSOProvider.class.isAssignableFrom(clazz) && !isAbstractClazz) {
                    this.classNames.get(ImplementationLookup.Type.JWT_SSO_PROVIDER).add(clazz.getName());
                    this.jwtSSOProviderClasses.add(clazz);
                }
                if (Reportlet.class.isAssignableFrom(clazz) && !isAbstractClazz) {
                    annotation = clazz.getAnnotation(ReportletConfClass.class);
                    if (annotation == null) {
                        LOG.warn("Found Reportlet {} without declared configuration", (Object)clazz.getName());
                    } else {
                        this.classNames.get(ImplementationLookup.Type.REPORTLET_CONF).add(annotation.value().getName());
                        this.reportletClasses.put(annotation.value(), clazz);
                    }
                }
                if (AccountRule.class.isAssignableFrom(clazz) && !isAbstractClazz) {
                    annotation = clazz.getAnnotation(AccountRuleConfClass.class);
                    if (annotation == null) {
                        LOG.warn("Found account policy rule {} without declared configuration", (Object)clazz.getName());
                    } else {
                        this.classNames.get(ImplementationLookup.Type.ACCOUNT_RULE_CONF).add(annotation.value().getName());
                        this.accountRuleClasses.put(annotation.value(), clazz);
                    }
                }
                if (PasswordRule.class.isAssignableFrom(clazz) && !isAbstractClazz) {
                    annotation = clazz.getAnnotation(PasswordRuleConfClass.class);
                    if (annotation == null) {
                        LOG.warn("Found password policy rule {} without declared configuration", (Object)clazz.getName());
                    } else {
                        this.classNames.get(ImplementationLookup.Type.PASSWORD_RULE_CONF).add(annotation.value().getName());
                        this.passwordRuleClasses.put(annotation.value(), clazz);
                    }
                }
                if (ItemTransformer.class.isAssignableFrom(clazz) && !isAbstractClazz && !clazz.equals(JEXLItemTransformerImpl.class)) {
                    this.classNames.get(ImplementationLookup.Type.ITEM_TRANSFORMER).add(clazz.getName());
                }
                if (!(!SchedTaskJobDelegate.class.isAssignableFrom(clazz) || isAbstractClazz || PullJobDelegate.class.isAssignableFrom(clazz) || PushJobDelegate.class.isAssignableFrom(clazz) || GroupMemberProvisionTaskJobDelegate.class.isAssignableFrom(clazz))) {
                    this.classNames.get(ImplementationLookup.Type.TASKJOBDELEGATE).add(bd.getBeanClassName());
                }
                if (ReconciliationFilterBuilder.class.isAssignableFrom(clazz) && !isAbstractClazz) {
                    this.classNames.get(ImplementationLookup.Type.RECONCILIATION_FILTER_BUILDER).add(bd.getBeanClassName());
                }
                if (LogicActions.class.isAssignableFrom(clazz) && !isAbstractClazz) {
                    this.classNames.get(ImplementationLookup.Type.LOGIC_ACTIONS).add(bd.getBeanClassName());
                }
                if (PropagationActions.class.isAssignableFrom(clazz) && !isAbstractClazz) {
                    this.classNames.get(ImplementationLookup.Type.PROPAGATION_ACTIONS).add(bd.getBeanClassName());
                }
                if (PullActions.class.isAssignableFrom(clazz) && !isAbstractClazz) {
                    this.classNames.get(ImplementationLookup.Type.PULL_ACTIONS).add(bd.getBeanClassName());
                }
                if (PushActions.class.isAssignableFrom(clazz) && !isAbstractClazz) {
                    this.classNames.get(ImplementationLookup.Type.PUSH_ACTIONS).add(bd.getBeanClassName());
                }
                if (PullCorrelationRule.class.isAssignableFrom(clazz) && !isAbstractClazz && !PlainAttrsPullCorrelationRule.class.isAssignableFrom(clazz)) {
                    this.classNames.get(ImplementationLookup.Type.PULL_CORRELATION_RULE).add(bd.getBeanClassName());
                }
                if (Validator.class.isAssignableFrom(clazz) && !isAbstractClazz) {
                    this.classNames.get(ImplementationLookup.Type.VALIDATOR).add(bd.getBeanClassName());
                }
                if (NotificationRecipientsProvider.class.isAssignableFrom(clazz) && !isAbstractClazz) {
                    this.classNames.get(ImplementationLookup.Type.NOTIFICATION_RECIPIENTS_PROVIDER).add(bd.getBeanClassName());
                }
                if (!AuditAppender.class.isAssignableFrom(clazz) || isAbstractClazz) continue;
                this.classNames.get(ImplementationLookup.Type.AUDIT_APPENDER).add(clazz.getName());
                this.auditAppenderClasses.add(clazz);
            }
            catch (Throwable t) {
                LOG.warn("Could not inspect class {}", (Object)bd.getBeanClassName(), (Object)t);
            }
        }
        this.classNames = Collections.unmodifiableMap(this.classNames);
        this.reportletClasses = Collections.unmodifiableMap(this.reportletClasses);
        this.accountRuleClasses = Collections.unmodifiableMap(this.accountRuleClasses);
        this.passwordRuleClasses = Collections.unmodifiableMap(this.passwordRuleClasses);
        LOG.debug("Implementation classes found: {}", this.classNames);
    }

    public Set<String> getClassNames(ImplementationLookup.Type type) {
        return this.classNames.get(type);
    }

    public Set<Class<?>> getJWTSSOProviderClasses() {
        return this.jwtSSOProviderClasses;
    }

    public Class<? extends Reportlet> getReportletClass(Class<? extends ReportletConf> reportletConfClass) {
        return this.reportletClasses.get(reportletConfClass);
    }

    public Class<? extends AccountRule> getAccountRuleClass(Class<? extends AccountRuleConf> accountRuleConfClass) {
        return this.accountRuleClasses.get(accountRuleConfClass);
    }

    public Class<? extends PasswordRule> getPasswordRuleClass(Class<? extends PasswordRuleConf> passwordRuleConfClass) {
        return this.passwordRuleClasses.get(passwordRuleConfClass);
    }

    public Set<Class<?>> getAuditAppenderClasses() {
        return this.auditAppenderClasses;
    }
}

