/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.cocoon;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.cocoon.pipeline.SetupException;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.component.CachingPipelineComponent;
import org.apache.cocoon.pipeline.util.StringRepresentation;
import org.apache.cocoon.sax.AbstractSAXTransformer;
import org.apache.cocoon.sax.SAXConsumer;
import org.apache.cocoon.sax.util.SAXConsumerAdapter;
import org.apache.syncope.core.provisioning.java.utils.VoidURIResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.ext.LexicalHandler;

public class XSLTTransformer
extends AbstractSAXTransformer
implements CachingPipelineComponent {
    private static final Logger LOG = LoggerFactory.getLogger(XSLTTransformer.class);
    private static final SAXTransformerFactory TRAX_FACTORY = XSLTTransformer.createNewSAXTransformerFactory();
    private static final Pattern XSLT_PARAMETER_NAME_PATTERN = Pattern.compile("[a-zA-Z_][\\w\\-\\.]*");
    private Map<String, Object> parameters;
    private Templates templates;
    private Source source;

    public XSLTTransformer(Source source) {
        this.load(source, null);
    }

    public XSLTTransformer(Source source, Map<String, Object> attributes) {
        this.load(source, attributes);
    }

    private void load(Source source, Map<String, Object> attributes) {
        if (source == null) {
            throw new IllegalArgumentException("The parameter 'source' mustn't be null.");
        }
        this.source = source;
        this.load(this.source, this.source.toString(), attributes);
    }

    private void load(Source source, String localCacheKey, Map<String, Object> attributes) {
        SAXTransformerFactory transformerFactory;
        LOG.debug("{} local cache miss: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)localCacheKey);
        if (attributes == null || attributes.isEmpty()) {
            transformerFactory = TRAX_FACTORY;
        } else {
            transformerFactory = XSLTTransformer.createNewSAXTransformerFactory();
            for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
                transformerFactory.setAttribute(attribute.getKey(), attribute.getValue());
            }
        }
        try {
            this.templates = transformerFactory.newTemplates(source);
        }
        catch (TransformerConfigurationException e) {
            throw new SetupException("Impossible to read XSLT from '" + source + "', see nested exception", (Throwable)e);
        }
    }

    public void setParameters(Map<String, ? extends Object> parameters) {
        this.parameters = parameters == null ? null : new HashMap<String, Object>(parameters);
    }

    protected void setSAXConsumer(SAXConsumer consumer) {
        TransformerHandler transformerHandler;
        try {
            transformerHandler = TRAX_FACTORY.newTransformerHandler(this.templates);
        }
        catch (Exception e) {
            throw new SetupException("Could not initialize transformer handler.", (Throwable)e);
        }
        if (this.parameters != null) {
            Transformer transformer = transformerHandler.getTransformer();
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                String name = entry.getKey();
                if (!XSLT_PARAMETER_NAME_PATTERN.matcher(name).matches()) continue;
                transformer.setParameter(name, entry.getValue());
            }
        }
        SAXResult result = new SAXResult();
        result.setHandler((ContentHandler)consumer);
        result.setLexicalHandler((LexicalHandler)consumer);
        transformerHandler.setResult(result);
        SAXConsumerAdapter saxConsumerAdapter = new SAXConsumerAdapter();
        saxConsumerAdapter.setContentHandler((ContentHandler)transformerHandler);
        super.setSAXConsumer((SAXConsumer)saxConsumerAdapter);
    }

    public CacheKey constructCacheKey() {
        return null;
    }

    private static SAXTransformerFactory createNewSAXTransformerFactory() {
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        transformerFactory.setURIResolver((URIResolver)new VoidURIResolver());
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            LOG.error("Could not enable secure XML processing", (Throwable)e);
        }
        return transformerFactory;
    }

    public String toString() {
        return StringRepresentation.buildString((Object)((Object)this), (String[])new String[]{"src=<" + this.source + ">"});
    }
}

