/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.BooleanReplacePatchItem;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.logic.SyncopeLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.LogicActions;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UserLogic
extends AbstractAnyLogic<UserTO, UserPatch> {
    @Autowired
    protected AnySearchDAO searchDAO;
    @Autowired
    protected UserDataBinder binder;
    @Autowired
    protected UserProvisioningManager provisioningManager;
    @Autowired
    protected SyncopeLogic syncopeLogic;

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public Pair<String, UserTO> selfRead() {
        return ImmutablePair.of((Object)POJOHelper.serialize((Object)AuthContextUtils.getAuthorizations()), (Object)this.binder.returnUserTO(this.binder.getAuthenticatedUserTO()));
    }

    @Override
    @PreAuthorize(value="hasRole('USER_READ')")
    @Transactional(readOnly=true)
    public UserTO read(String key) {
        return this.binder.returnUserTO(this.binder.getUserTO(key));
    }

    @Override
    @PreAuthorize(value="hasRole('USER_SEARCH')")
    @Transactional(readOnly=true)
    public Pair<Integer, List<UserTO>> search(SearchCond searchCond, int page, int size, List<OrderByClause> orderBy, String realm, final boolean details) {
        int count = this.searchDAO.count(RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_SEARCH")), (String)realm), searchCond == null ? this.userDAO.getAllMatchingCond() : searchCond, AnyTypeKind.USER);
        List matching = this.searchDAO.search(RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_SEARCH")), (String)realm), searchCond == null ? this.userDAO.getAllMatchingCond() : searchCond, page, size, orderBy, AnyTypeKind.USER);
        List result = (List)CollectionUtils.collect((Iterable)matching, (Transformer)new Transformer<User, UserTO>(){

            @Transactional(readOnly=true)
            public UserTO transform(User input) {
                return UserLogic.this.binder.returnUserTO(UserLogic.this.binder.getUserTO(input, details));
            }
        }, new ArrayList());
        return Pair.of((Object)count, (Object)result);
    }

    @PreAuthorize(value="isAnonymous() or hasRole('ANONYMOUS')")
    public ProvisioningResult<UserTO> selfCreate(UserTO userTO, boolean storePassword, boolean nullPriorityAsync) {
        return this.doCreate(userTO, storePassword, true, nullPriorityAsync);
    }

    @PreAuthorize(value="hasRole('USER_CREATE')")
    public ProvisioningResult<UserTO> create(UserTO userTO, boolean storePassword, boolean nullPriorityAsync) {
        return this.doCreate(userTO, storePassword, false, nullPriorityAsync);
    }

    protected ProvisioningResult<UserTO> doCreate(UserTO userTO, boolean storePassword, boolean self, boolean nullPriorityAsync) {
        Pair<UserTO, List<LogicActions>> before = this.beforeCreate(userTO);
        if (((UserTO)before.getLeft()).getRealm() == null) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
        }
        if (!self) {
            Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_CREATE")), (String)((UserTO)before.getLeft()).getRealm());
            this.securityChecks(effectiveRealms, ((UserTO)before.getLeft()).getRealm(), null);
        }
        Pair created = this.provisioningManager.create((UserTO)before.getLeft(), storePassword, nullPriorityAsync);
        return this.afterCreate(this.binder.returnUserTO(this.binder.getUserTO((String)created.getKey())), (List)created.getRight(), (List)before.getRight());
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    public ProvisioningResult<UserTO> selfUpdate(UserPatch userPatch, boolean nullPriorityAsync) {
        UserTO userTO = this.binder.getAuthenticatedUserTO();
        userPatch.setKey(userTO.getKey());
        return this.doUpdate(userPatch, true, nullPriorityAsync);
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> update(UserPatch userPatch, boolean nullPriorityAsync) {
        return this.doUpdate(userPatch, false, nullPriorityAsync);
    }

    protected ProvisioningResult<UserTO> doUpdate(UserPatch userPatch, boolean self, boolean nullPriorityAsync) {
        UserTO userTO = this.binder.getUserTO(userPatch.getKey());
        HashSet<String> dynRealmsBefore = new HashSet<String>(userTO.getDynRealms());
        Pair<UserPatch, List<LogicActions>> before = this.beforeUpdate(userPatch, userTO.getRealm());
        boolean authDynRealms = false;
        if (!self && ((UserPatch)before.getLeft()).getRealm() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)((UserPatch)before.getLeft()).getRealm().getValue()))) {
            Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_UPDATE")), (String)((String)((UserPatch)before.getLeft()).getRealm().getValue()));
            authDynRealms = this.securityChecks(effectiveRealms, (String)((UserPatch)before.getLeft()).getRealm().getValue(), ((UserPatch)before.getLeft()).getKey());
        }
        Pair updated = this.provisioningManager.update((AnyPatch)before.getLeft(), nullPriorityAsync);
        return this.afterUpdate(this.binder.returnUserTO(this.binder.getUserTO(((UserPatch)updated.getLeft()).getKey())), (List)updated.getRight(), (List)before.getRight(), authDynRealms, dynRealmsBefore);
    }

    protected Pair<String, List<PropagationStatus>> setStatusOnWfAdapter(StatusPatch statusPatch, boolean nullPriorityAsync) {
        Pair updated;
        switch (statusPatch.getType()) {
            case SUSPEND: {
                updated = this.provisioningManager.suspend(statusPatch, nullPriorityAsync);
                break;
            }
            case REACTIVATE: {
                updated = this.provisioningManager.reactivate(statusPatch, nullPriorityAsync);
                break;
            }
            default: {
                updated = this.provisioningManager.activate(statusPatch, nullPriorityAsync);
            }
        }
        return updated;
    }

    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> status(StatusPatch statusPatch, boolean nullPriorityAsync) {
        UserTO toUpdate = this.binder.getUserTO(statusPatch.getKey());
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_UPDATE")), (String)toUpdate.getRealm());
        this.securityChecks(effectiveRealms, toUpdate.getRealm(), toUpdate.getKey());
        statusPatch.setKey(toUpdate.getKey());
        Pair<String, List<PropagationStatus>> updated = this.setStatusOnWfAdapter(statusPatch, nullPriorityAsync);
        return this.afterUpdate(this.binder.returnUserTO(this.binder.getUserTO((String)updated.getKey())), (List)updated.getRight(), Collections.emptyList(), false, Collections.emptySet());
    }

    @PreAuthorize(value="isAuthenticated()")
    public ProvisioningResult<UserTO> selfStatus(StatusPatch statusPatch, boolean nullPriorityAsync) {
        statusPatch.setKey(this.userDAO.findKey(AuthContextUtils.getUsername()));
        Pair<String, List<PropagationStatus>> updated = this.setStatusOnWfAdapter(statusPatch, nullPriorityAsync);
        return this.afterUpdate(this.binder.returnUserTO(this.binder.getUserTO((String)updated.getKey())), (List)updated.getRight(), Collections.emptyList(), false, Collections.emptySet());
    }

    @PreAuthorize(value="hasRole('MUST_CHANGE_PASSWORD')")
    public ProvisioningResult<UserTO> changePassword(String password, boolean nullPriorityAsync) {
        UserPatch userPatch = new UserPatch();
        userPatch.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value((Object)password)).build());
        userPatch.setMustChangePassword((BooleanReplacePatchItem)((BooleanReplacePatchItem.Builder)new BooleanReplacePatchItem.Builder().value((Object)false)).build());
        return this.selfUpdate(userPatch, nullPriorityAsync);
    }

    @PreAuthorize(value="isAnonymous() or hasRole('ANONYMOUS')")
    @Transactional
    public void requestPasswordReset(String username, String securityAnswer) {
        if (username == null) {
            throw new NotFoundException("Null username");
        }
        User user = this.userDAO.findByUsername(username);
        if (user == null) {
            throw new NotFoundException("User " + username);
        }
        if (this.syncopeLogic.isPwdResetRequiringSecurityQuestions() && (securityAnswer == null || !securityAnswer.equals(user.getSecurityAnswer()))) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSecurityAnswer);
        }
        this.provisioningManager.requestPasswordReset(user.getKey());
    }

    @PreAuthorize(value="isAnonymous() or hasRole('ANONYMOUS')")
    @Transactional
    public void confirmPasswordReset(String token, String password) {
        User user = this.userDAO.findByToken(token);
        if (user == null) {
            throw new NotFoundException("User with token " + token);
        }
        this.provisioningManager.confirmPasswordReset(user.getKey(), token, password);
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    public ProvisioningResult<UserTO> selfDelete(boolean nullPriorityAsync) {
        UserTO userTO = this.binder.getAuthenticatedUserTO();
        return this.doDelete(userTO, true, nullPriorityAsync);
    }

    @Override
    @PreAuthorize(value="hasRole('USER_DELETE')")
    public ProvisioningResult<UserTO> delete(String key, boolean nullPriorityAsync) {
        UserTO userTO = this.binder.getUserTO(key);
        return this.doDelete(userTO, false, nullPriorityAsync);
    }

    protected ProvisioningResult<UserTO> doDelete(UserTO userTO, boolean self, boolean nullPriorityAsync) {
        UserTO deletedTO;
        List ownedGroups;
        Pair<UserTO, List<LogicActions>> before = this.beforeDelete(userTO);
        if (!self) {
            Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_DELETE")), (String)((UserTO)before.getLeft()).getRealm());
            this.securityChecks(effectiveRealms, ((UserTO)before.getLeft()).getRealm(), ((UserTO)before.getLeft()).getKey());
        }
        if (!(ownedGroups = this.groupDAO.findOwnedByUser(((UserTO)before.getLeft()).getKey())).isEmpty()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.GroupOwnership);
            sce.getElements().addAll(CollectionUtils.collect((Iterable)ownedGroups, (Transformer)new Transformer<Group, String>(){

                public String transform(Group group) {
                    return group.getKey() + " " + group.getName();
                }
            }, new ArrayList()));
            throw sce;
        }
        List statuses = this.provisioningManager.delete(((UserTO)before.getLeft()).getKey(), nullPriorityAsync);
        if (this.userDAO.find(((UserTO)before.getLeft()).getKey()) == null) {
            deletedTO = new UserTO();
            deletedTO.setKey(((UserTO)before.getLeft()).getKey());
        } else {
            deletedTO = this.binder.getUserTO(((UserTO)before.getLeft()).getKey());
        }
        return this.afterDelete(this.binder.returnUserTO(deletedTO), statuses, (List)before.getRight());
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public UserTO unlink(String key, Collection<String> resources) {
        UserTO user = this.binder.getUserTO(key);
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_UPDATE")), (String)user.getRealm());
        this.securityChecks(effectiveRealms, user.getRealm(), user.getKey());
        UserPatch patch = new UserPatch();
        patch.setKey(key);
        patch.getResources().addAll(CollectionUtils.collect(resources, (Transformer)new Transformer<String, StringPatchItem>(){

            public StringPatchItem transform(String resource) {
                return (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value((Object)resource)).build();
            }
        }));
        return this.binder.returnUserTO(this.binder.getUserTO(this.provisioningManager.unlink((AnyPatch)patch)));
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public UserTO link(String key, Collection<String> resources) {
        UserTO user = this.binder.getUserTO(key);
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_UPDATE")), (String)user.getRealm());
        this.securityChecks(effectiveRealms, user.getRealm(), user.getKey());
        UserPatch patch = new UserPatch();
        patch.setKey(key);
        patch.getResources().addAll(CollectionUtils.collect(resources, (Transformer)new Transformer<String, StringPatchItem>(){

            public StringPatchItem transform(String resource) {
                return (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value((Object)resource)).build();
            }
        }));
        return this.binder.returnUserTO(this.binder.getUserTO(this.provisioningManager.link((AnyPatch)patch)));
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> unassign(String key, Collection<String> resources, boolean nullPriorityAsync) {
        UserTO user = this.binder.getUserTO(key);
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_UPDATE")), (String)user.getRealm());
        this.securityChecks(effectiveRealms, user.getRealm(), user.getKey());
        UserPatch patch = new UserPatch();
        patch.setKey(key);
        patch.getResources().addAll(CollectionUtils.collect(resources, (Transformer)new Transformer<String, StringPatchItem>(){

            public StringPatchItem transform(String resource) {
                return (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value((Object)resource)).build();
            }
        }));
        return this.update(patch, nullPriorityAsync);
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> assign(String key, Collection<String> resources, boolean changepwd, String password, boolean nullPriorityAsync) {
        UserTO user = this.binder.getUserTO(key);
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_UPDATE")), (String)user.getRealm());
        this.securityChecks(effectiveRealms, user.getRealm(), user.getKey());
        UserPatch patch = new UserPatch();
        patch.setKey(key);
        patch.getResources().addAll(CollectionUtils.collect(resources, (Transformer)new Transformer<String, StringPatchItem>(){

            public StringPatchItem transform(String resource) {
                return (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value((Object)resource)).build();
            }
        }));
        if (changepwd) {
            patch.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value((Object)password)).onSyncope(false).resources(resources).build());
        }
        return this.update(patch, nullPriorityAsync);
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> deprovision(String key, Collection<String> resources, boolean nullPriorityAsync) {
        UserTO user = this.binder.getUserTO(key);
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_UPDATE")), (String)user.getRealm());
        this.securityChecks(effectiveRealms, user.getRealm(), user.getKey());
        List statuses = this.provisioningManager.deprovision(key, resources, nullPriorityAsync);
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.returnUserTO(this.binder.getUserTO(key)));
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> provision(String key, Collection<String> resources, boolean changePwd, String password, boolean nullPriorityAsync) {
        UserTO user = this.binder.getUserTO(key);
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_UPDATE")), (String)user.getRealm());
        this.securityChecks(effectiveRealms, user.getRealm(), user.getKey());
        List statuses = this.provisioningManager.provision(key, changePwd, password, resources, nullPriorityAsync);
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.returnUserTO(this.binder.getUserTO(key)));
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    @Override
    protected UserTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if ("requestPasswordReset".equals(method.getName())) {
            key = this.userDAO.findKey((String)args[0]);
        } else if (!"confirmPasswordReset".equals(method.getName()) && ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (args[i] instanceof UserTO) {
                    key = ((UserTO)args[i]).getKey();
                    continue;
                }
                if (args[i] instanceof UserPatch) {
                    key = ((UserPatch)args[i]).getKey();
                    continue;
                }
                if (!(args[i] instanceof StatusPatch)) continue;
                key = ((StatusPatch)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getUserTO(key);
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

