/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.DerSchemaTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.to.VirSchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.provisioning.api.data.SchemaDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component
public class SchemaLogic
extends AbstractTransactionalLogic<SchemaTO> {
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private DerSchemaDAO derSchemaDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private AnyTypeClassDAO anyTypeClassDAO;
    @Autowired
    private SchemaDataBinder binder;

    private boolean doesSchemaExist(SchemaType schemaType, String name) {
        boolean found;
        switch (schemaType) {
            case VIRTUAL: {
                found = this.virSchemaDAO.find(name) != null;
                break;
            }
            case DERIVED: {
                found = this.derSchemaDAO.find(name) != null;
                break;
            }
            case PLAIN: {
                found = this.plainSchemaDAO.find(name) != null;
                break;
            }
            default: {
                found = false;
            }
        }
        return found;
    }

    @PreAuthorize(value="hasRole('SCHEMA_CREATE')")
    public <T extends SchemaTO> T create(SchemaType schemaType, T schemaTO) {
        VirSchemaTO created;
        if (StringUtils.isBlank((CharSequence)schemaTO.getKey())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add("Schema key");
            throw sce;
        }
        if (this.doesSchemaExist(schemaType, schemaTO.getKey())) {
            throw new DuplicateException(schemaType + "/" + schemaTO.getKey());
        }
        switch (schemaType) {
            case VIRTUAL: {
                VirSchema virSchema = (VirSchema)this.virSchemaDAO.save((Schema)this.binder.create((VirSchemaTO)schemaTO));
                created = this.binder.getVirSchemaTO(virSchema);
                break;
            }
            case DERIVED: {
                DerSchema derSchema = (DerSchema)this.derSchemaDAO.save((Schema)this.binder.create((DerSchemaTO)schemaTO));
                created = this.binder.getDerSchemaTO(derSchema);
                break;
            }
            default: {
                PlainSchema plainSchema = (PlainSchema)this.plainSchemaDAO.save((Schema)this.binder.create((PlainSchemaTO)schemaTO));
                created = this.binder.getPlainSchemaTO(plainSchema);
            }
        }
        return (T)created;
    }

    @PreAuthorize(value="hasRole('SCHEMA_DELETE')")
    public void delete(SchemaType schemaType, String schemaKey) {
        if (!this.doesSchemaExist(schemaType, schemaKey)) {
            throw new NotFoundException(schemaType + "/" + schemaKey);
        }
        switch (schemaType) {
            case VIRTUAL: {
                this.virSchemaDAO.delete(schemaKey);
                break;
            }
            case DERIVED: {
                this.derSchemaDAO.delete(schemaKey);
                break;
            }
            default: {
                this.plainSchemaDAO.delete(schemaKey);
            }
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    public <T extends SchemaTO> List<T> list(SchemaType schemaType, List<String> anyTypeClasses) {
        return this.doSearch(schemaType, anyTypeClasses, null);
    }

    @PreAuthorize(value="isAuthenticated()")
    public <T extends SchemaTO> List<T> search(SchemaType schemaType, List<String> anyTypeClasses, String keyword) {
        return this.doSearch(schemaType, anyTypeClasses, keyword == null ? null : keyword.replace('*', '%'));
    }

    private <T extends SchemaTO> List<T> doSearch(SchemaType schemaType, List<String> anyTypeClasses, String keyword) {
        List result;
        ArrayList<AnyTypeClass> classes = new ArrayList<AnyTypeClass>(anyTypeClasses == null ? 0 : anyTypeClasses.size());
        if (anyTypeClasses != null) {
            anyTypeClasses.remove(AnyTypeKind.USER.name());
            anyTypeClasses.remove(AnyTypeKind.GROUP.name());
            for (String anyTypeClass : anyTypeClasses) {
                AnyTypeClass clazz = this.anyTypeClassDAO.find(anyTypeClass);
                if (clazz == null) {
                    LOG.warn("Ignoring invalid {}: {}", (Object)AnyTypeClass.class.getSimpleName(), (Object)anyTypeClass);
                    continue;
                }
                classes.add(clazz);
            }
        }
        switch (schemaType) {
            case VIRTUAL: {
                result = (List)CollectionUtils.collect((Iterable)(classes.isEmpty() ? (keyword == null ? this.virSchemaDAO.findAll() : this.virSchemaDAO.findByKeyword(keyword)) : this.virSchemaDAO.findByAnyTypeClasses(classes)), (Transformer)new Transformer<VirSchema, T>(){

                    public T transform(VirSchema input) {
                        return SchemaLogic.this.binder.getVirSchemaTO(input);
                    }
                }, new ArrayList());
                break;
            }
            case DERIVED: {
                result = (List)CollectionUtils.collect((Iterable)(classes.isEmpty() ? (keyword == null ? this.derSchemaDAO.findAll() : this.derSchemaDAO.findByKeyword(keyword)) : this.derSchemaDAO.findByAnyTypeClasses(classes)), (Transformer)new Transformer<DerSchema, T>(){

                    public T transform(DerSchema input) {
                        return SchemaLogic.this.binder.getDerSchemaTO(input);
                    }
                }, new ArrayList());
                break;
            }
            default: {
                result = (List)CollectionUtils.collect((Iterable)(classes.isEmpty() ? (keyword == null ? this.plainSchemaDAO.findAll() : this.plainSchemaDAO.findByKeyword(keyword)) : this.plainSchemaDAO.findByAnyTypeClasses(classes)), (Transformer)new Transformer<PlainSchema, T>(){

                    public T transform(PlainSchema input) {
                        return SchemaLogic.this.binder.getPlainSchemaTO(input);
                    }
                }, new ArrayList());
            }
        }
        return result;
    }

    @PreAuthorize(value="isAuthenticated()")
    public <T extends SchemaTO> T read(SchemaType schemaType, String schemaKey) {
        VirSchemaTO read;
        switch (schemaType) {
            case VIRTUAL: {
                VirSchema virSchema = (VirSchema)this.virSchemaDAO.find(schemaKey);
                if (virSchema == null) {
                    throw new NotFoundException("Virtual Schema '" + schemaKey + "'");
                }
                read = this.binder.getVirSchemaTO(virSchema);
                break;
            }
            case DERIVED: {
                DerSchema derSchema = (DerSchema)this.derSchemaDAO.find(schemaKey);
                if (derSchema == null) {
                    throw new NotFoundException("Derived schema '" + schemaKey + "'");
                }
                read = this.binder.getDerSchemaTO(derSchema);
                break;
            }
            default: {
                PlainSchema schema = (PlainSchema)this.plainSchemaDAO.find(schemaKey);
                if (schema == null) {
                    throw new NotFoundException("Schema '" + schemaKey + "'");
                }
                read = this.binder.getPlainSchemaTO(schema);
            }
        }
        return (T)read;
    }

    @PreAuthorize(value="hasRole('SCHEMA_UPDATE')")
    public <T extends SchemaTO> void update(SchemaType schemaType, T schemaTO) {
        if (!this.doesSchemaExist(schemaType, schemaTO.getKey())) {
            throw new NotFoundException(schemaType + "/" + schemaTO.getKey());
        }
        switch (schemaType) {
            case VIRTUAL: {
                VirSchema virSchema = (VirSchema)this.virSchemaDAO.find(schemaTO.getKey());
                if (virSchema == null) {
                    throw new NotFoundException("Virtual Schema '" + schemaTO.getKey() + "'");
                }
                this.virSchemaDAO.save((Schema)this.binder.update((VirSchemaTO)schemaTO, virSchema));
                break;
            }
            case DERIVED: {
                DerSchema derSchema = (DerSchema)this.derSchemaDAO.find(schemaTO.getKey());
                if (derSchema == null) {
                    throw new NotFoundException("Derived schema '" + schemaTO.getKey() + "'");
                }
                this.derSchemaDAO.save((Schema)this.binder.update((DerSchemaTO)schemaTO, derSchema));
                break;
            }
            default: {
                PlainSchema plainSchema = (PlainSchema)this.plainSchemaDAO.find(schemaTO.getKey());
                if (plainSchema == null) {
                    throw new NotFoundException("Schema '" + schemaTO.getKey() + "'");
                }
                this.plainSchemaDAO.save((Schema)this.binder.update((PlainSchemaTO)schemaTO, plainSchema));
            }
        }
    }

    @Override
    protected SchemaTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String kind = null;
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; (key == null || kind == null) && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    if (kind == null) {
                        kind = (String)args[i];
                        continue;
                    }
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof SchemaTO)) continue;
                key = ((SchemaTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                PlainSchemaTO result = null;
                PlainSchema plainSchema = (PlainSchema)this.plainSchemaDAO.find(key);
                if (plainSchema == null) {
                    DerSchema derSchema = (DerSchema)this.derSchemaDAO.find(key);
                    if (derSchema == null) {
                        VirSchema virSchema = (VirSchema)this.virSchemaDAO.find(key);
                        if (virSchema != null) {
                            result = this.binder.getVirSchemaTO(virSchema);
                        }
                    } else {
                        result = this.binder.getDerSchemaTO(derSchema);
                    }
                } else {
                    result = this.binder.getPlainSchemaTO(plainSchema);
                }
                return result;
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

