/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.provisioning.api.data.RoleDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class RoleLogic
extends AbstractTransactionalLogic<RoleTO> {
    @Autowired
    private RoleDataBinder binder;
    @Autowired
    private RoleDAO roleDAO;

    @PreAuthorize(value="hasRole('ROLE_READ')")
    @Transactional(readOnly=true)
    public RoleTO read(String key) {
        Role role = this.roleDAO.find(key);
        if (role == null) {
            LOG.error("Could not find role '" + key + "'");
            throw new NotFoundException(key);
        }
        return this.binder.getRoleTO(role);
    }

    @PreAuthorize(value="hasRole('ROLE_LIST')")
    @Transactional(readOnly=true)
    public List<RoleTO> list() {
        return (List)CollectionUtils.collect((Iterable)this.roleDAO.findAll(), (Transformer)new Transformer<Role, RoleTO>(){

            public RoleTO transform(Role input) {
                return RoleLogic.this.binder.getRoleTO(input);
            }
        }, new ArrayList());
    }

    @PreAuthorize(value="hasRole('ROLE_CREATE')")
    public RoleTO create(RoleTO roleTO) {
        return this.binder.getRoleTO(this.roleDAO.save(this.binder.create(roleTO)));
    }

    @PreAuthorize(value="hasRole('ROLE_UPDATE')")
    public RoleTO update(RoleTO roleTO) {
        Role role = this.roleDAO.find(roleTO.getKey());
        if (role == null) {
            LOG.error("Could not find role '" + roleTO.getKey() + "'");
            throw new NotFoundException(roleTO.getKey());
        }
        return this.binder.getRoleTO(this.roleDAO.save(this.binder.update(role, roleTO)));
    }

    @PreAuthorize(value="hasRole('ROLE_DELETE')")
    public RoleTO delete(String key) {
        Role role = this.roleDAO.find(key);
        if (role == null) {
            LOG.error("Could not find role '" + key + "'");
            throw new NotFoundException(key);
        }
        RoleTO deleted = this.binder.getRoleTO(role);
        this.roleDAO.delete(key);
        return deleted;
    }

    @PreAuthorize(value="isAuthenticated()")
    public String getConsoleLayoutInfo(String key) {
        Role role = this.roleDAO.find(key);
        if (role == null) {
            LOG.error("Could not find role '" + key + "'");
            throw new NotFoundException(key);
        }
        String consoleLayout = role.getConsoleLayoutInfo();
        if (StringUtils.isBlank((CharSequence)consoleLayout)) {
            LOG.error("Could not find console layout for Role '" + key + "'");
            throw new NotFoundException("Console layout for role " + key);
        }
        return consoleLayout;
    }

    @PreAuthorize(value="hasRole('ROLE_UPDATE')")
    public void setConsoleLayoutInfo(String key, String consoleLayout) {
        Role role = this.roleDAO.find(key);
        if (role == null) {
            LOG.error("Could not find role '" + key + "'");
            throw new NotFoundException(key);
        }
        role.setConsoleLayoutInfo(consoleLayout);
        this.roleDAO.save(role);
    }

    @Override
    protected RoleTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof RoleTO)) continue;
                key = ((RoleTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getRoleTO(this.roleDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

