/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.common.lib.to.ResourceHistoryConfTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceHistoryConfDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResourceHistoryConf;
import org.apache.syncope.core.provisioning.api.data.ResourceDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component
public class ResourceHistoryLogic
extends AbstractTransactionalLogic<ResourceHistoryConfTO> {
    @Autowired
    private ExternalResourceHistoryConfDAO resourceHistoryConfDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private ResourceDataBinder binder;

    private ResourceHistoryConfTO getResourceHistoryConfTO(ExternalResourceHistoryConf history) {
        ResourceHistoryConfTO historyTO = new ResourceHistoryConfTO();
        historyTO.setKey(history.getKey());
        historyTO.setCreator(history.getCreator());
        historyTO.setCreation(history.getCreation());
        historyTO.setResourceTO((ResourceTO)history.getConf());
        return historyTO;
    }

    @PreAuthorize(value="hasRole('RESOURCE_HISTORY_LIST')")
    public List<ResourceHistoryConfTO> list(String key) {
        ExternalResource resource = this.resourceDAO.find(key);
        if (resource == null) {
            throw new NotFoundException("Resource '" + key + "'");
        }
        return (List)CollectionUtils.collect((Iterable)this.resourceHistoryConfDAO.findByEntity(resource), (Transformer)new Transformer<ExternalResourceHistoryConf, ResourceHistoryConfTO>(){

            public ResourceHistoryConfTO transform(ExternalResourceHistoryConf input) {
                return ResourceHistoryLogic.this.getResourceHistoryConfTO(input);
            }
        }, new ArrayList());
    }

    @PreAuthorize(value="hasRole('RESOURCE_HISTORY_RESTORE')")
    public void restore(String key) {
        ExternalResourceHistoryConf resourceHistoryConf = this.resourceHistoryConfDAO.find(key);
        if (resourceHistoryConf == null) {
            throw new NotFoundException("Resource History Conf '" + key + "'");
        }
        this.binder.update((ExternalResource)resourceHistoryConf.getEntity(), (ResourceTO)resourceHistoryConf.getConf());
    }

    @PreAuthorize(value="hasRole('RESOURCE_HISTORY_DELETE')")
    public void delete(String key) {
        ExternalResourceHistoryConf resourceHistoryConf = this.resourceHistoryConfDAO.find(key);
        if (resourceHistoryConf == null) {
            throw new NotFoundException("Resource History Conf '" + key + "'");
        }
        this.resourceHistoryConfDAO.delete(key);
    }

    @Override
    protected ResourceHistoryConfTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        if (!"list".equals(method.getName())) {
            try {
                String key = (String)args[0];
                return this.getResourceHistoryConfTO(this.resourceHistoryConfDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

