/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ReportTemplateTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ReportTemplateFormat;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.dao.ReportTemplateDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component
public class ReportTemplateLogic
extends AbstractTransactionalLogic<ReportTemplateTO> {
    @Autowired
    private ReportTemplateDAO reportTemplateDAO;
    @Autowired
    private ReportDAO reportDAO;
    @Autowired
    private EntityFactory entityFactory;

    private ReportTemplateTO getReportTemplateTO(String key) {
        ReportTemplateTO reportTemplateTO = new ReportTemplateTO();
        reportTemplateTO.setKey(key);
        return reportTemplateTO;
    }

    @PreAuthorize(value="hasRole('REPORT_TEMPLATE_READ')")
    public ReportTemplateTO read(String key) {
        ReportTemplate reportTemplate = this.reportTemplateDAO.find(key);
        if (reportTemplate == null) {
            LOG.error("Could not find report template '" + key + "'");
            throw new NotFoundException(key);
        }
        return this.getReportTemplateTO(key);
    }

    @PreAuthorize(value="hasRole('REPORT_TEMPLATE_LIST')")
    public List<ReportTemplateTO> list() {
        return (List)CollectionUtils.collect((Iterable)this.reportTemplateDAO.findAll(), (Transformer)new Transformer<ReportTemplate, ReportTemplateTO>(){

            public ReportTemplateTO transform(ReportTemplate input) {
                return ReportTemplateLogic.this.getReportTemplateTO(input.getKey());
            }
        }, new ArrayList());
    }

    @PreAuthorize(value="hasRole('REPORT_TEMPLATE_CREATE')")
    public ReportTemplateTO create(String key) {
        if (this.reportTemplateDAO.find(key) != null) {
            throw new DuplicateException(key);
        }
        ReportTemplate reportTemplate = (ReportTemplate)this.entityFactory.newEntity(ReportTemplate.class);
        reportTemplate.setKey(key);
        this.reportTemplateDAO.save(reportTemplate);
        return this.getReportTemplateTO(key);
    }

    @PreAuthorize(value="hasRole('REPORT_TEMPLATE_READ')")
    public String getFormat(String key, ReportTemplateFormat format) {
        String template;
        ReportTemplate reportTemplate = this.reportTemplateDAO.find(key);
        if (reportTemplate == null) {
            LOG.error("Could not find report template '" + key + "'");
            throw new NotFoundException(key);
        }
        String string = format == ReportTemplateFormat.HTML ? reportTemplate.getHTMLTemplate() : (template = format == ReportTemplateFormat.CSV ? reportTemplate.getCSVTemplate() : reportTemplate.getFOTemplate());
        if (StringUtils.isBlank((CharSequence)template)) {
            LOG.error("Could not find report template '" + key + "' in " + format + " format");
            throw new NotFoundException(key + " in " + format);
        }
        return template;
    }

    @PreAuthorize(value="hasRole('REPORT_TEMPLATE_UPDATE')")
    public void setFormat(String key, ReportTemplateFormat format, String template) {
        ReportTemplate reportTemplate = this.reportTemplateDAO.find(key);
        if (reportTemplate == null) {
            LOG.error("Could not find report template '" + key + "'");
            throw new NotFoundException(key);
        }
        switch (format) {
            case CSV: {
                reportTemplate.setCSVTemplate(template);
                break;
            }
            case FO: {
                reportTemplate.setFOTemplate(template);
                break;
            }
            case HTML: {
                reportTemplate.setHTMLTemplate(template);
                break;
            }
        }
        this.reportTemplateDAO.save(reportTemplate);
    }

    @PreAuthorize(value="hasRole('REPORT_TEMPLATE_DELETE')")
    public ReportTemplateTO delete(String key) {
        ReportTemplate reportTemplate = this.reportTemplateDAO.find(key);
        if (reportTemplate == null) {
            LOG.error("Could not find report template '" + key + "'");
            throw new NotFoundException(key);
        }
        List reports = this.reportDAO.findByTemplate(reportTemplate);
        if (!reports.isEmpty()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InUseByNotifications);
            sce.getElements().addAll(CollectionUtils.collect((Iterable)reports, (Transformer)new Transformer<Report, String>(){

                public String transform(Report report) {
                    return String.valueOf(report.getKey());
                }
            }, new ArrayList()));
            throw sce;
        }
        ReportTemplateTO deleted = this.getReportTemplateTO(key);
        this.reportTemplateDAO.delete(key);
        return deleted;
    }

    @Override
    protected ReportTemplateTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = ((String)args[i]).toString();
                    continue;
                }
                if (!(args[i] instanceof ReportTemplateTO)) continue;
                key = ((ReportTemplateTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.getReportTemplateTO(key);
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

