/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.RelationshipTypeTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.provisioning.api.data.RelationshipTypeDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component
public class RelationshipTypeLogic
extends AbstractTransactionalLogic<RelationshipTypeTO> {
    @Autowired
    private RelationshipTypeDataBinder binder;
    @Autowired
    private RelationshipTypeDAO relationshipTypeDAO;

    @PreAuthorize(value="hasRole('RELATIONSHIPTYPE_READ')")
    public RelationshipTypeTO read(String key) {
        RelationshipType relationshipType = this.relationshipTypeDAO.find(key);
        if (relationshipType == null) {
            LOG.error("Could not find relationshipType '" + key + "'");
            throw new NotFoundException(key);
        }
        return this.binder.getRelationshipTypeTO(relationshipType);
    }

    @PreAuthorize(value="hasRole('RELATIONSHIPTYPE_LIST')")
    public List<RelationshipTypeTO> list() {
        return (List)CollectionUtils.collect((Iterable)this.relationshipTypeDAO.findAll(), (Transformer)new Transformer<RelationshipType, RelationshipTypeTO>(){

            public RelationshipTypeTO transform(RelationshipType input) {
                return RelationshipTypeLogic.this.binder.getRelationshipTypeTO(input);
            }
        }, new ArrayList());
    }

    @PreAuthorize(value="hasRole('RELATIONSHIPTYPE_CREATE')")
    public RelationshipTypeTO create(RelationshipTypeTO relationshipTypeTO) {
        return this.binder.getRelationshipTypeTO(this.relationshipTypeDAO.save(this.binder.create(relationshipTypeTO)));
    }

    @PreAuthorize(value="hasRole('RELATIONSHIPTYPE_UPDATE')")
    public RelationshipTypeTO update(RelationshipTypeTO relationshipTypeTO) {
        RelationshipType relationshipType = this.relationshipTypeDAO.find(relationshipTypeTO.getKey());
        if (relationshipType == null) {
            LOG.error("Could not find relationshipType '" + relationshipTypeTO.getKey() + "'");
            throw new NotFoundException(relationshipTypeTO.getKey());
        }
        this.binder.update(relationshipType, relationshipTypeTO);
        relationshipType = this.relationshipTypeDAO.save(relationshipType);
        return this.binder.getRelationshipTypeTO(relationshipType);
    }

    @PreAuthorize(value="hasRole('RELATIONSHIPTYPE_DELETE')")
    public RelationshipTypeTO delete(String key) {
        RelationshipType relationshipType = this.relationshipTypeDAO.find(key);
        if (relationshipType == null) {
            LOG.error("Could not find relationshipType '" + key + "'");
            throw new NotFoundException(key);
        }
        RelationshipTypeTO deleted = this.binder.getRelationshipTypeTO(relationshipType);
        this.relationshipTypeDAO.delete(key);
        return deleted;
    }

    @Override
    protected RelationshipTypeTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof Long) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof RelationshipTypeTO)) continue;
                key = ((RelationshipTypeTO)args[i]).getKey();
            }
        }
        if (StringUtils.isNotBlank(key)) {
            try {
                return this.binder.getRelationshipTypeTO(this.relationshipTypeDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

