/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.MailTemplateTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MailTemplateFormat;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.MailTemplateDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.MailTemplate;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component
public class MailTemplateLogic
extends AbstractTransactionalLogic<MailTemplateTO> {
    @Autowired
    private MailTemplateDAO mailTemplateDAO;
    @Autowired
    private NotificationDAO notificationDAO;
    @Autowired
    private EntityFactory entityFactory;

    private MailTemplateTO getMailTemplateTO(String key) {
        MailTemplateTO mailTemplateTO = new MailTemplateTO();
        mailTemplateTO.setKey(key);
        return mailTemplateTO;
    }

    @PreAuthorize(value="hasRole('MAIL_TEMPLATE_READ')")
    public MailTemplateTO read(String key) {
        MailTemplate mailTemplate = this.mailTemplateDAO.find(key);
        if (mailTemplate == null) {
            LOG.error("Could not find mail template '" + key + "'");
            throw new NotFoundException(key);
        }
        return this.getMailTemplateTO(key);
    }

    @PreAuthorize(value="hasRole('MAIL_TEMPLATE_LIST')")
    public List<MailTemplateTO> list() {
        return (List)CollectionUtils.collect((Iterable)this.mailTemplateDAO.findAll(), (Transformer)new Transformer<MailTemplate, MailTemplateTO>(){

            public MailTemplateTO transform(MailTemplate input) {
                return MailTemplateLogic.this.getMailTemplateTO(input.getKey());
            }
        }, new ArrayList());
    }

    @PreAuthorize(value="hasRole('MAIL_TEMPLATE_CREATE')")
    public MailTemplateTO create(String key) {
        if (this.mailTemplateDAO.find(key) != null) {
            throw new DuplicateException(key);
        }
        MailTemplate mailTemplate = (MailTemplate)this.entityFactory.newEntity(MailTemplate.class);
        mailTemplate.setKey(key);
        this.mailTemplateDAO.save(mailTemplate);
        return this.getMailTemplateTO(key);
    }

    @PreAuthorize(value="hasRole('MAIL_TEMPLATE_READ')")
    public String getFormat(String key, MailTemplateFormat format) {
        String template;
        MailTemplate mailTemplate = this.mailTemplateDAO.find(key);
        if (mailTemplate == null) {
            LOG.error("Could not find mail template '" + key + "'");
            throw new NotFoundException(key);
        }
        String string = template = format == MailTemplateFormat.HTML ? mailTemplate.getHTMLTemplate() : mailTemplate.getTextTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            LOG.error("Could not find mail template '" + key + "' in " + format + " format");
            throw new NotFoundException(key + " in " + format);
        }
        return template;
    }

    @PreAuthorize(value="hasRole('MAIL_TEMPLATE_UPDATE')")
    public void setFormat(String key, MailTemplateFormat format, String template) {
        MailTemplate mailTemplate = this.mailTemplateDAO.find(key);
        if (mailTemplate == null) {
            LOG.error("Could not find mail template '" + key + "'");
            throw new NotFoundException(key);
        }
        if (format == MailTemplateFormat.HTML) {
            mailTemplate.setHTMLTemplate(template);
        } else {
            mailTemplate.setTextTemplate(template);
        }
        this.mailTemplateDAO.save(mailTemplate);
    }

    @PreAuthorize(value="hasRole('MAIL_TEMPLATE_DELETE')")
    public MailTemplateTO delete(String key) {
        MailTemplate mailTemplate = this.mailTemplateDAO.find(key);
        if (mailTemplate == null) {
            LOG.error("Could not find mail template '" + key + "'");
            throw new NotFoundException(key);
        }
        List notifications = this.notificationDAO.findByTemplate(mailTemplate);
        if (!notifications.isEmpty()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InUseByNotifications);
            sce.getElements().addAll(CollectionUtils.collect((Iterable)notifications, (Transformer)new Transformer<Notification, String>(){

                public String transform(Notification notification) {
                    return String.valueOf(notification.getKey());
                }
            }, new ArrayList()));
            throw sce;
        }
        MailTemplateTO deleted = this.getMailTemplateTO(key);
        this.mailTemplateDAO.delete(key);
        return deleted;
    }

    @Override
    protected MailTemplateTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = ((String)args[i]).toString();
                    continue;
                }
                if (!(args[i] instanceof MailTemplateTO)) continue;
                key = ((MailTemplateTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.getMailTemplateTO(key);
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

